/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.FieldNameValidator;
import me.lucko.helper.mongo.external.bson.io.BsonOutput;
import me.lucko.helper.mongo.external.mongodriver.connection.MessageSettings;
import me.lucko.helper.mongo.external.mongodriver.connection.RequestMessage;
import me.lucko.helper.mongo.external.mongodriver.internal.validator.NoOpFieldNameValidator;

class CommandMessage
extends RequestMessage {
    private final boolean slaveOk;
    private final BsonDocument command;
    private final FieldNameValidator validator;

    CommandMessage(String collectionName, BsonDocument command, boolean slaveOk, MessageSettings settings) {
        this(collectionName, command, slaveOk, new NoOpFieldNameValidator(), settings);
    }

    CommandMessage(String collectionName, BsonDocument command, boolean slaveOk, FieldNameValidator validator, MessageSettings settings) {
        super(collectionName, RequestMessage.OpCode.OP_QUERY, settings);
        this.slaveOk = slaveOk;
        this.command = command;
        this.validator = validator;
    }

    @Override
    protected RequestMessage encodeMessageBody(BsonOutput bsonOutput, int messageStartPosition) {
        return this.encodeMessageBodyWithMetadata(bsonOutput, messageStartPosition).getNextMessage();
    }

    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput bsonOutput, int messageStartPosition) {
        bsonOutput.writeInt32(this.slaveOk ? 4 : 0);
        bsonOutput.writeCString(this.getCollectionName());
        bsonOutput.writeInt32(0);
        bsonOutput.writeInt32(-1);
        int firstDocumentPosition = bsonOutput.getPosition();
        this.addDocument(this.command, bsonOutput, this.validator);
        return new RequestMessage.EncodingMetadata(null, firstDocumentPosition);
    }
}

