/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.client.model.geojson.codecs;

import me.lucko.helper.mongo.external.bson.BsonReader;
import me.lucko.helper.mongo.external.bson.BsonWriter;
import me.lucko.helper.mongo.external.bson.codecs.Codec;
import me.lucko.helper.mongo.external.bson.codecs.DecoderContext;
import me.lucko.helper.mongo.external.bson.codecs.EncoderContext;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecConfigurationException;
import me.lucko.helper.mongo.external.mongodriver.client.model.geojson.CoordinateReferenceSystem;
import me.lucko.helper.mongo.external.mongodriver.client.model.geojson.NamedCoordinateReferenceSystem;
import me.lucko.helper.mongo.external.mongodriver.client.model.geojson.codecs.GeometryDecoderHelper;

public class NamedCoordinateReferenceSystemCodec
implements Codec<NamedCoordinateReferenceSystem> {
    @Override
    public void encode(BsonWriter writer, NamedCoordinateReferenceSystem value, EncoderContext encoderContext) {
        writer.writeStartDocument();
        writer.writeString("type", value.getType().getTypeName());
        writer.writeStartDocument("properties");
        writer.writeString("name", value.getName());
        writer.writeEndDocument();
        writer.writeEndDocument();
    }

    @Override
    public Class<NamedCoordinateReferenceSystem> getEncoderClass() {
        return NamedCoordinateReferenceSystem.class;
    }

    @Override
    public NamedCoordinateReferenceSystem decode(BsonReader reader, DecoderContext decoderContext) {
        CoordinateReferenceSystem crs = GeometryDecoderHelper.decodeCoordinateReferenceSystem(reader);
        if (crs == null || !(crs instanceof NamedCoordinateReferenceSystem)) {
            throw new CodecConfigurationException("Invalid NamedCoordinateReferenceSystem.");
        }
        return (NamedCoordinateReferenceSystem)crs;
    }
}

