/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.client.model.geojson.codecs;

import java.util.List;
import me.lucko.helper.mongo.external.bson.BsonWriter;
import me.lucko.helper.mongo.external.bson.codecs.Codec;
import me.lucko.helper.mongo.external.bson.codecs.EncoderContext;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecConfigurationException;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecRegistry;
import me.lucko.helper.mongo.external.mongodriver.client.model.geojson.Geometry;
import me.lucko.helper.mongo.external.mongodriver.client.model.geojson.GeometryCollection;
import me.lucko.helper.mongo.external.mongodriver.client.model.geojson.LineString;
import me.lucko.helper.mongo.external.mongodriver.client.model.geojson.MultiLineString;
import me.lucko.helper.mongo.external.mongodriver.client.model.geojson.MultiPoint;
import me.lucko.helper.mongo.external.mongodriver.client.model.geojson.MultiPolygon;
import me.lucko.helper.mongo.external.mongodriver.client.model.geojson.Point;
import me.lucko.helper.mongo.external.mongodriver.client.model.geojson.Polygon;
import me.lucko.helper.mongo.external.mongodriver.client.model.geojson.PolygonCoordinates;
import me.lucko.helper.mongo.external.mongodriver.client.model.geojson.Position;

final class GeometryEncoderHelper {
    static void encodeGeometry(BsonWriter writer, Geometry value, EncoderContext encoderContext, CodecRegistry registry) {
        writer.writeStartDocument();
        writer.writeString("type", value.getType().getTypeName());
        if (value instanceof GeometryCollection) {
            writer.writeName("geometries");
            GeometryEncoderHelper.encodeGeometryCollection(writer, (GeometryCollection)value, encoderContext, registry);
        } else {
            writer.writeName("coordinates");
            if (value instanceof Point) {
                GeometryEncoderHelper.encodePoint(writer, (Point)value);
            } else if (value instanceof MultiPoint) {
                GeometryEncoderHelper.encodeMultiPoint(writer, (MultiPoint)value);
            } else if (value instanceof Polygon) {
                GeometryEncoderHelper.encodePolygon(writer, (Polygon)value);
            } else if (value instanceof MultiPolygon) {
                GeometryEncoderHelper.encodeMultiPolygon(writer, (MultiPolygon)value);
            } else if (value instanceof LineString) {
                GeometryEncoderHelper.encodeLineString(writer, (LineString)value);
            } else if (value instanceof MultiLineString) {
                GeometryEncoderHelper.encodeMultiLineString(writer, (MultiLineString)value);
            } else {
                throw new CodecConfigurationException(String.format("Unsupported Geometry: %s", value));
            }
        }
        GeometryEncoderHelper.encodeCoordinateReferenceSystem(writer, value, encoderContext, registry);
        writer.writeEndDocument();
    }

    private static void encodePoint(BsonWriter writer, Point value) {
        GeometryEncoderHelper.encodePosition(writer, value.getPosition());
    }

    private static void encodeMultiPoint(BsonWriter writer, MultiPoint value) {
        writer.writeStartArray();
        for (Position position : value.getCoordinates()) {
            GeometryEncoderHelper.encodePosition(writer, position);
        }
        writer.writeEndArray();
    }

    private static void encodePolygon(BsonWriter writer, Polygon value) {
        GeometryEncoderHelper.encodePolygonCoordinates(writer, value.getCoordinates());
    }

    private static void encodeMultiPolygon(BsonWriter writer, MultiPolygon value) {
        writer.writeStartArray();
        for (PolygonCoordinates polygonCoordinates : value.getCoordinates()) {
            GeometryEncoderHelper.encodePolygonCoordinates(writer, polygonCoordinates);
        }
        writer.writeEndArray();
    }

    private static void encodeLineString(BsonWriter writer, LineString value) {
        writer.writeStartArray();
        for (Position position : value.getCoordinates()) {
            GeometryEncoderHelper.encodePosition(writer, position);
        }
        writer.writeEndArray();
    }

    private static void encodeMultiLineString(BsonWriter writer, MultiLineString value) {
        writer.writeStartArray();
        for (List<Position> ring : value.getCoordinates()) {
            writer.writeStartArray();
            for (Position position : ring) {
                GeometryEncoderHelper.encodePosition(writer, position);
            }
            writer.writeEndArray();
        }
        writer.writeEndArray();
    }

    private static void encodeGeometryCollection(BsonWriter writer, GeometryCollection value, EncoderContext encoderContext, CodecRegistry registry) {
        writer.writeStartArray();
        for (Geometry geometry : value.getGeometries()) {
            GeometryEncoderHelper.encodeGeometry(writer, geometry, encoderContext, registry);
        }
        writer.writeEndArray();
    }

    static void encodeCoordinateReferenceSystem(BsonWriter writer, Geometry geometry, EncoderContext encoderContext, CodecRegistry registry) {
        if (geometry.getCoordinateReferenceSystem() != null) {
            writer.writeName("crs");
            Codec<?> codec = registry.get(geometry.getCoordinateReferenceSystem().getClass());
            encoderContext.encodeWithChildContext(codec, writer, geometry.getCoordinateReferenceSystem());
        }
    }

    static void encodePolygonCoordinates(BsonWriter writer, PolygonCoordinates polygonCoordinates) {
        writer.writeStartArray();
        GeometryEncoderHelper.encodeLinearRing(polygonCoordinates.getExterior(), writer);
        for (List<Position> ring : polygonCoordinates.getHoles()) {
            GeometryEncoderHelper.encodeLinearRing(ring, writer);
        }
        writer.writeEndArray();
    }

    private static void encodeLinearRing(List<Position> ring, BsonWriter writer) {
        writer.writeStartArray();
        for (Position position : ring) {
            GeometryEncoderHelper.encodePosition(writer, position);
        }
        writer.writeEndArray();
    }

    static void encodePosition(BsonWriter writer, Position value) {
        writer.writeStartArray();
        for (double number : value.getValues()) {
            writer.writeDouble(number);
        }
        writer.writeEndArray();
    }

    private GeometryEncoderHelper() {
    }
}

