/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.client.model.geojson;

import java.io.StringWriter;
import me.lucko.helper.mongo.external.bson.codecs.Codec;
import me.lucko.helper.mongo.external.bson.codecs.EncoderContext;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecRegistries;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecRegistry;
import me.lucko.helper.mongo.external.bson.json.JsonWriter;
import me.lucko.helper.mongo.external.bson.json.JsonWriterSettings;
import me.lucko.helper.mongo.external.mongodriver.client.model.geojson.CoordinateReferenceSystem;
import me.lucko.helper.mongo.external.mongodriver.client.model.geojson.GeoJsonObjectType;
import me.lucko.helper.mongo.external.mongodriver.client.model.geojson.codecs.GeoJsonCodecProvider;

public abstract class Geometry {
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new GeoJsonCodecProvider());
    private final CoordinateReferenceSystem coordinateReferenceSystem;

    protected Geometry() {
        this(null);
    }

    protected Geometry(CoordinateReferenceSystem coordinateReferenceSystem) {
        this.coordinateReferenceSystem = coordinateReferenceSystem;
    }

    public abstract GeoJsonObjectType getType();

    public String toJson() {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter(stringWriter, new JsonWriterSettings());
        Codec<?> codec = Geometry.getRegistry().get(this.getClass());
        codec.encode(writer, this, EncoderContext.builder().build());
        return stringWriter.toString();
    }

    static CodecRegistry getRegistry() {
        return REGISTRY;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.coordinateReferenceSystem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Geometry geometry = (Geometry)o;
        return !(this.coordinateReferenceSystem != null ? !this.coordinateReferenceSystem.equals(geometry.coordinateReferenceSystem) : geometry.coordinateReferenceSystem != null);
    }

    public int hashCode() {
        return this.coordinateReferenceSystem != null ? this.coordinateReferenceSystem.hashCode() : 0;
    }
}

