/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.client.model;

import java.util.concurrent.TimeUnit;
import me.lucko.helper.mongo.external.bson.conversions.Bson;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.client.model.Collation;

public class FindOneAndDeleteOptions {
    private Bson projection;
    private Bson sort;
    private long maxTimeMS;
    private Collation collation;

    public Bson getProjection() {
        return this.projection;
    }

    public FindOneAndDeleteOptions projection(Bson projection) {
        this.projection = projection;
        return this;
    }

    public Bson getSort() {
        return this.sort;
    }

    public FindOneAndDeleteOptions sort(Bson sort) {
        this.sort = sort;
        return this;
    }

    public FindOneAndDeleteOptions maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public Collation getCollation() {
        return this.collation;
    }

    public FindOneAndDeleteOptions collation(Collation collation) {
        this.collation = collation;
        return this;
    }
}

