/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver;

import me.lucko.helper.mongo.external.bson.BsonDocumentWrapper;
import me.lucko.helper.mongo.external.bson.codecs.Encoder;
import me.lucko.helper.mongo.external.mongodriver.DBObject;
import me.lucko.helper.mongo.external.mongodriver.WriteRequest;
import me.lucko.helper.mongo.external.mongodriver.bulk.UpdateRequest;
import me.lucko.helper.mongo.external.mongodriver.bulk.WriteRequest;
import me.lucko.helper.mongo.external.mongodriver.client.model.Collation;

class ReplaceRequest
extends WriteRequest {
    private final DBObject query;
    private final DBObject document;
    private final boolean upsert;
    private final Encoder<DBObject> codec;
    private final Encoder<DBObject> replacementCodec;
    private final Collation collation;

    ReplaceRequest(DBObject query, DBObject document, boolean upsert, Encoder<DBObject> codec, Encoder<DBObject> replacementCodec, Collation collation) {
        this.query = query;
        this.document = document;
        this.upsert = upsert;
        this.codec = codec;
        this.replacementCodec = replacementCodec;
        this.collation = collation;
    }

    public DBObject getQuery() {
        return this.query;
    }

    public DBObject getDocument() {
        return this.document;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public Collation getCollation() {
        return this.collation;
    }

    @Override
    me.lucko.helper.mongo.external.mongodriver.bulk.WriteRequest toNew() {
        return new UpdateRequest(new BsonDocumentWrapper<DBObject>(this.query, this.codec), new BsonDocumentWrapper<DBObject>(this.document, this.replacementCodec), WriteRequest.Type.REPLACE).upsert(this.isUpsert()).collation(this.getCollation());
    }
}

