/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver;

import java.util.Collection;
import java.util.Iterator;
import me.lucko.helper.mongo.external.mongodriver.Block;
import me.lucko.helper.mongo.external.mongodriver.Function;
import me.lucko.helper.mongo.external.mongodriver.MappingIterable;
import me.lucko.helper.mongo.external.mongodriver.MongoBatchCursorAdapter;
import me.lucko.helper.mongo.external.mongodriver.ReadPreference;
import me.lucko.helper.mongo.external.mongodriver.client.MongoCursor;
import me.lucko.helper.mongo.external.mongodriver.client.MongoIterable;
import me.lucko.helper.mongo.external.mongodriver.operation.BatchCursor;
import me.lucko.helper.mongo.external.mongodriver.operation.OperationExecutor;
import me.lucko.helper.mongo.external.mongodriver.operation.ReadOperation;

class OperationIterable<T>
implements MongoIterable<T> {
    private final ReadOperation<? extends BatchCursor<T>> operation;
    private final ReadPreference readPreference;
    private final OperationExecutor executor;

    OperationIterable(ReadOperation<? extends BatchCursor<T>> operation, ReadPreference readPreference, OperationExecutor executor) {
        this.operation = operation;
        this.readPreference = readPreference;
        this.executor = executor;
    }

    @Override
    public MongoCursor<T> iterator() {
        return new MongoBatchCursorAdapter<T>(this.executor.execute(this.operation, this.readPreference));
    }

    @Override
    public T first() {
        Iterator cursor = this.iterator();
        try {
            if (!cursor.hasNext()) {
                T t = null;
                return t;
            }
            Object TResult = cursor.next();
            return (T)TResult;
        }
        finally {
            cursor.close();
        }
    }

    @Override
    public <U> MongoIterable<U> map(Function<T, U> mapper) {
        return new MappingIterable<T, U>(this, mapper);
    }

    @Override
    public void forEach(Block<? super T> block) {
        Iterator cursor = this.iterator();
        try {
            while (cursor.hasNext()) {
                block.apply(cursor.next());
            }
        }
        finally {
            cursor.close();
        }
    }

    @Override
    public <A extends Collection<? super T>> A into(final A target) {
        this.forEach(new Block<T>(){

            @Override
            public void apply(T t) {
                target.add(t);
            }
        });
        return target;
    }

    @Override
    public MongoIterable<T> batchSize(int batchSize) {
        throw new UnsupportedOperationException();
    }
}

