/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.lucko.helper.mongo.external.bson.BsonBoolean;
import me.lucko.helper.mongo.external.mongodriver.BasicDBObject;
import me.lucko.helper.mongo.external.mongodriver.Bytes;
import me.lucko.helper.mongo.external.mongodriver.CommandResult;
import me.lucko.helper.mongo.external.mongodriver.DB;
import me.lucko.helper.mongo.external.mongodriver.DBObject;
import me.lucko.helper.mongo.external.mongodriver.DBObjects;
import me.lucko.helper.mongo.external.mongodriver.Function;
import me.lucko.helper.mongo.external.mongodriver.MongoClient;
import me.lucko.helper.mongo.external.mongodriver.MongoClientOptions;
import me.lucko.helper.mongo.external.mongodriver.MongoClientURI;
import me.lucko.helper.mongo.external.mongodriver.MongoCredential;
import me.lucko.helper.mongo.external.mongodriver.MongoNamespace;
import me.lucko.helper.mongo.external.mongodriver.MongoOptions;
import me.lucko.helper.mongo.external.mongodriver.MongoURI;
import me.lucko.helper.mongo.external.mongodriver.OperationIterable;
import me.lucko.helper.mongo.external.mongodriver.ReadConcern;
import me.lucko.helper.mongo.external.mongodriver.ReadPreference;
import me.lucko.helper.mongo.external.mongodriver.ReplicaSetStatus;
import me.lucko.helper.mongo.external.mongodriver.ServerAddress;
import me.lucko.helper.mongo.external.mongodriver.ServerCursor;
import me.lucko.helper.mongo.external.mongodriver.WriteConcern;
import me.lucko.helper.mongo.external.mongodriver.annotations.ThreadSafe;
import me.lucko.helper.mongo.external.mongodriver.binding.ClusterBinding;
import me.lucko.helper.mongo.external.mongodriver.binding.ConnectionSource;
import me.lucko.helper.mongo.external.mongodriver.binding.ReadBinding;
import me.lucko.helper.mongo.external.mongodriver.binding.ReadWriteBinding;
import me.lucko.helper.mongo.external.mongodriver.binding.SingleServerBinding;
import me.lucko.helper.mongo.external.mongodriver.binding.WriteBinding;
import me.lucko.helper.mongo.external.mongodriver.client.MongoDriverInformation;
import me.lucko.helper.mongo.external.mongodriver.connection.BufferProvider;
import me.lucko.helper.mongo.external.mongodriver.connection.Cluster;
import me.lucko.helper.mongo.external.mongodriver.connection.ClusterConnectionMode;
import me.lucko.helper.mongo.external.mongodriver.connection.ClusterDescription;
import me.lucko.helper.mongo.external.mongodriver.connection.ClusterSettings;
import me.lucko.helper.mongo.external.mongodriver.connection.ClusterType;
import me.lucko.helper.mongo.external.mongodriver.connection.Connection;
import me.lucko.helper.mongo.external.mongodriver.connection.DefaultClusterFactory;
import me.lucko.helper.mongo.external.mongodriver.connection.ServerDescription;
import me.lucko.helper.mongo.external.mongodriver.connection.SocketStreamFactory;
import me.lucko.helper.mongo.external.mongodriver.event.ClusterListener;
import me.lucko.helper.mongo.external.mongodriver.internal.connection.PowerOfTwoBufferPool;
import me.lucko.helper.mongo.external.mongodriver.internal.event.EventListenerHelper;
import me.lucko.helper.mongo.external.mongodriver.internal.thread.DaemonThreadFactory;
import me.lucko.helper.mongo.external.mongodriver.operation.CurrentOpOperation;
import me.lucko.helper.mongo.external.mongodriver.operation.FsyncUnlockOperation;
import me.lucko.helper.mongo.external.mongodriver.operation.ListDatabasesOperation;
import me.lucko.helper.mongo.external.mongodriver.operation.OperationExecutor;
import me.lucko.helper.mongo.external.mongodriver.operation.ReadOperation;
import me.lucko.helper.mongo.external.mongodriver.operation.WriteOperation;
import me.lucko.helper.mongo.external.mongodriver.selector.LatencyMinimizingServerSelector;

@ThreadSafe
public class Mongo {
    static final String ADMIN_DATABASE_NAME = "admin";
    private final ConcurrentMap<String, DB> dbCache = new ConcurrentHashMap<String, DB>();
    private volatile WriteConcern writeConcern;
    private volatile ReadPreference readPreference;
    private final ReadConcern readConcern;
    private final MongoClientOptions options;
    private final List<MongoCredential> credentialsList;
    private final Bytes.OptionHolder optionHolder;
    private final Cluster cluster;
    private final BufferProvider bufferProvider = new PowerOfTwoBufferPool();
    private final ConcurrentLinkedQueue<ServerCursorAndNamespace> orphanedCursors = new ConcurrentLinkedQueue();
    private final ExecutorService cursorCleaningService;

    @Deprecated
    public Mongo() {
        this(new ServerAddress(), Mongo.createLegacyOptions());
    }

    @Deprecated
    public Mongo(String host) {
        this(new ServerAddress(host), Mongo.createLegacyOptions());
    }

    @Deprecated
    public Mongo(String host, MongoOptions options) {
        this(new ServerAddress(host), options.toClientOptions());
    }

    @Deprecated
    public Mongo(String host, int port) {
        this(new ServerAddress(host, port), Mongo.createLegacyOptions());
    }

    @Deprecated
    public Mongo(ServerAddress address) {
        this(address, Mongo.createLegacyOptions());
    }

    @Deprecated
    public Mongo(ServerAddress address, MongoOptions options) {
        this(address, options.toClientOptions());
    }

    @Deprecated
    public Mongo(ServerAddress left, ServerAddress right) {
        this(Arrays.asList(left, right), Mongo.createLegacyOptions());
    }

    @Deprecated
    public Mongo(ServerAddress left, ServerAddress right, MongoOptions options) {
        this(Arrays.asList(left, right), options.toClientOptions());
    }

    @Deprecated
    public Mongo(List<ServerAddress> seeds) {
        this(seeds, Mongo.createLegacyOptions());
    }

    @Deprecated
    public Mongo(List<ServerAddress> seeds, MongoOptions options) {
        this(seeds, options.toClientOptions());
    }

    @Deprecated
    public Mongo(MongoURI uri) {
        this(uri.toClientURI());
    }

    Mongo(List<ServerAddress> seedList, MongoClientOptions options) {
        this(seedList, Collections.emptyList(), options);
    }

    Mongo(ServerAddress serverAddress, MongoClientOptions options) {
        this(serverAddress, Collections.emptyList(), options);
    }

    Mongo(ServerAddress serverAddress, List<MongoCredential> credentialsList, MongoClientOptions options) {
        this(serverAddress, credentialsList, options, null);
    }

    Mongo(ServerAddress serverAddress, List<MongoCredential> credentialsList, MongoClientOptions options, MongoDriverInformation mongoDriverInformation) {
        this(Mongo.createCluster(serverAddress, credentialsList, options, mongoDriverInformation), options, credentialsList);
    }

    Mongo(List<ServerAddress> seedList, List<MongoCredential> credentialsList, MongoClientOptions options) {
        this(seedList, credentialsList, options, null);
    }

    Mongo(List<ServerAddress> seedList, List<MongoCredential> credentialsList, MongoClientOptions options, MongoDriverInformation mongoDriverInformation) {
        this(Mongo.createCluster(seedList, credentialsList, options, mongoDriverInformation), options, credentialsList);
    }

    Mongo(MongoClientURI mongoURI) {
        this(mongoURI, null);
    }

    Mongo(MongoClientURI mongoURI, MongoDriverInformation mongoDriverInformation) {
        this(Mongo.createCluster(mongoURI, mongoDriverInformation), mongoURI.getOptions(), mongoURI.getCredentials() != null ? Arrays.asList(mongoURI.getCredentials()) : Collections.emptyList());
    }

    Mongo(Cluster cluster, MongoClientOptions options, List<MongoCredential> credentialsList) {
        this.cluster = cluster;
        this.options = options;
        this.readPreference = options.getReadPreference() != null ? options.getReadPreference() : ReadPreference.primary();
        this.writeConcern = options.getWriteConcern() != null ? options.getWriteConcern() : WriteConcern.UNACKNOWLEDGED;
        this.readConcern = options.getReadConcern() != null ? options.getReadConcern() : ReadConcern.DEFAULT;
        this.optionHolder = new Bytes.OptionHolder(null);
        this.credentialsList = Collections.unmodifiableList(credentialsList);
        this.cursorCleaningService = options.isCursorFinalizerEnabled() ? this.createCursorCleaningService() : null;
    }

    @Deprecated
    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    @Deprecated
    public void setReadPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    public List<ServerAddress> getAllAddress() {
        return this.cluster.getSettings().getHosts();
    }

    public List<ServerAddress> getServerAddressList() {
        ArrayList<ServerAddress> serverAddresses = new ArrayList<ServerAddress>();
        for (ServerDescription cur : this.getClusterDescription().getServerDescriptions()) {
            serverAddresses.add(cur.getAddress());
        }
        return serverAddresses;
    }

    private ClusterDescription getClusterDescription() {
        return this.cluster.getDescription();
    }

    public ServerAddress getAddress() {
        ClusterDescription description = this.getClusterDescription();
        if (description.getPrimaries().isEmpty()) {
            return null;
        }
        return description.getPrimaries().get(0).getAddress();
    }

    @Deprecated
    public MongoOptions getMongoOptions() {
        return new MongoOptions(this.getMongoClientOptions());
    }

    public ReplicaSetStatus getReplicaSetStatus() {
        ClusterDescription clusterDescription = this.getClusterDescription();
        return clusterDescription.getType() == ClusterType.REPLICA_SET && clusterDescription.getConnectionMode() == ClusterConnectionMode.MULTIPLE ? new ReplicaSetStatus(this.cluster) : null;
    }

    @Deprecated
    public List<String> getDatabaseNames() {
        return new OperationIterable<DBObject>(new ListDatabasesOperation<DBObject>(MongoClient.getCommandCodec()), ReadPreference.primary(), this.createOperationExecutor()).map(new Function<DBObject, String>(){

            @Override
            public String apply(DBObject result) {
                return (String)result.get("name");
            }
        }).into(new ArrayList());
    }

    @Deprecated
    public DB getDB(String dbName) {
        DB db = (DB)this.dbCache.get(dbName);
        if (db != null) {
            return db;
        }
        db = new DB(this, dbName, this.createOperationExecutor());
        DB temp = this.dbCache.putIfAbsent(dbName, db);
        if (temp != null) {
            return temp;
        }
        return db;
    }

    public Collection<DB> getUsedDatabases() {
        return this.dbCache.values();
    }

    public void dropDatabase(String dbName) {
        this.getDB(dbName).dropDatabase();
    }

    public void close() {
        this.cluster.close();
        if (this.cursorCleaningService != null) {
            this.cursorCleaningService.shutdownNow();
        }
    }

    @Deprecated
    public void slaveOk() {
        this.addOption(4);
    }

    @Deprecated
    public void setOptions(int options) {
        this.optionHolder.set(options);
    }

    @Deprecated
    public void resetOptions() {
        this.optionHolder.reset();
    }

    @Deprecated
    public void addOption(int option) {
        this.optionHolder.add(option);
    }

    @Deprecated
    public int getOptions() {
        return this.optionHolder.get();
    }

    public CommandResult fsync(boolean async) {
        BasicDBObject command = new BasicDBObject("fsync", (Object)1);
        if (async) {
            command.put("async", (Object)1);
        }
        return this.getDB(ADMIN_DATABASE_NAME).command(command);
    }

    public CommandResult fsyncAndLock() {
        BasicDBObject command = new BasicDBObject("fsync", (Object)1);
        command.put("lock", (Object)1);
        return this.getDB(ADMIN_DATABASE_NAME).command(command);
    }

    public DBObject unlock() {
        return DBObjects.toDBObject(this.execute(new FsyncUnlockOperation(), this.readPreference));
    }

    public boolean isLocked() {
        return this.execute(new CurrentOpOperation(), ReadPreference.primary()).getBoolean("fsyncLock", BsonBoolean.FALSE).getValue();
    }

    public String toString() {
        return "Mongo{options=" + this.getMongoClientOptions() + '}';
    }

    public int getMaxBsonObjectSize() {
        List<ServerDescription> primaries = this.getClusterDescription().getPrimaries();
        return primaries.isEmpty() ? ServerDescription.getDefaultMaxDocumentSize() : primaries.get(0).getMaxDocumentSize();
    }

    public String getConnectPoint() {
        ServerAddress master = this.getAddress();
        return master != null ? String.format("%s:%d", master.getHost(), master.getPort()) : null;
    }

    private static MongoClientOptions createLegacyOptions() {
        return MongoClientOptions.builder().legacyDefaults().build();
    }

    private static Cluster createCluster(MongoClientURI mongoURI, MongoDriverInformation mongoDriverInformation) {
        List<MongoCredential> credentialList;
        List<MongoCredential> list = credentialList = mongoURI.getCredentials() != null ? Collections.singletonList(mongoURI.getCredentials()) : Collections.emptyList();
        if (mongoURI.getHosts().size() == 1) {
            return Mongo.createCluster(new ServerAddress(mongoURI.getHosts().get(0)), credentialList, mongoURI.getOptions(), null);
        }
        ArrayList<ServerAddress> seedList = new ArrayList<ServerAddress>(mongoURI.getHosts().size());
        for (String host : mongoURI.getHosts()) {
            seedList.add(new ServerAddress(host));
        }
        return Mongo.createCluster(seedList, credentialList, mongoURI.getOptions(), mongoDriverInformation);
    }

    private static Cluster createCluster(List<ServerAddress> seedList, List<MongoCredential> credentialsList, MongoClientOptions options, MongoDriverInformation mongoDriverInformation) {
        return Mongo.createCluster(Mongo.getClusterSettings(seedList, options, ClusterConnectionMode.MULTIPLE), credentialsList, options, mongoDriverInformation);
    }

    private static Cluster createCluster(ServerAddress serverAddress, List<MongoCredential> credentialsList, MongoClientOptions options, MongoDriverInformation mongoDriverInformation) {
        return Mongo.createCluster(Mongo.getClusterSettings(Collections.singletonList(serverAddress), options, Mongo.getSingleServerClusterMode(options)), credentialsList, options, mongoDriverInformation);
    }

    private static Cluster createCluster(ClusterSettings clusterSettings, List<MongoCredential> credentialsList, MongoClientOptions options, MongoDriverInformation mongoDriverInformation) {
        return new DefaultClusterFactory().createCluster(clusterSettings, options.getServerSettings(), options.getConnectionPoolSettings(), new SocketStreamFactory(options.getSocketSettings(), options.getSslSettings(), options.getSocketFactory()), new SocketStreamFactory(options.getHeartbeatSocketSettings(), options.getSslSettings(), options.getSocketFactory()), credentialsList, EventListenerHelper.getCommandListener(options.getCommandListeners()), options.getApplicationName(), mongoDriverInformation);
    }

    private static ClusterSettings getClusterSettings(List<ServerAddress> seedList, MongoClientOptions options, ClusterConnectionMode clusterConnectionMode) {
        ClusterSettings.Builder builder = ClusterSettings.builder().hosts(new ArrayList<ServerAddress>(seedList)).mode(clusterConnectionMode).requiredReplicaSetName(options.getRequiredReplicaSetName()).serverSelectionTimeout(options.getServerSelectionTimeout(), TimeUnit.MILLISECONDS).serverSelector(new LatencyMinimizingServerSelector(options.getLocalThreshold(), TimeUnit.MILLISECONDS)).description(options.getDescription()).maxWaitQueueSize(options.getConnectionPoolSettings().getMaxWaitQueueSize());
        for (ClusterListener clusterListener : options.getClusterListeners()) {
            builder.addClusterListener(clusterListener);
        }
        return builder.build();
    }

    Cluster getCluster() {
        return this.cluster;
    }

    Bytes.OptionHolder getOptionHolder() {
        return this.optionHolder;
    }

    BufferProvider getBufferProvider() {
        return this.bufferProvider;
    }

    MongoClientOptions getMongoClientOptions() {
        return this.options;
    }

    List<MongoCredential> getCredentialsList() {
        return this.credentialsList;
    }

    WriteBinding getWriteBinding() {
        return this.getReadWriteBinding(ReadPreference.primary());
    }

    ReadBinding getReadBinding(ReadPreference readPreference) {
        return this.getReadWriteBinding(readPreference);
    }

    private ReadWriteBinding getReadWriteBinding(ReadPreference readPreference) {
        return new ClusterBinding(this.getCluster(), readPreference);
    }

    void addOrphanedCursor(ServerCursor serverCursor, MongoNamespace namespace) {
        this.orphanedCursors.add(new ServerCursorAndNamespace(serverCursor, namespace));
    }

    OperationExecutor createOperationExecutor() {
        return new OperationExecutor(){

            @Override
            public <T> T execute(ReadOperation<T> operation, ReadPreference readPreference) {
                return Mongo.this.execute(operation, readPreference);
            }

            @Override
            public <T> T execute(WriteOperation<T> operation) {
                return Mongo.this.execute(operation);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T execute(ReadOperation<T> operation, ReadPreference readPreference) {
        ReadBinding binding = this.getReadBinding(readPreference);
        try {
            T t = operation.execute(binding);
            return t;
        }
        finally {
            binding.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T execute(WriteOperation<T> operation) {
        WriteBinding binding = this.getWriteBinding();
        try {
            T t = operation.execute(binding);
            return t;
        }
        finally {
            binding.release();
        }
    }

    private ExecutorService createCursorCleaningService() {
        ScheduledExecutorService newTimer = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory("CleanCursors"));
        newTimer.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Mongo.this.cleanCursors();
            }
        }, 1L, 1L, TimeUnit.SECONDS);
        return newTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanCursors() {
        ServerCursorAndNamespace cur;
        while ((cur = this.orphanedCursors.poll()) != null) {
            SingleServerBinding binding = new SingleServerBinding(this.cluster, cur.serverCursor.getAddress());
            try {
                ConnectionSource source = binding.getReadConnectionSource();
                try {
                    Connection connection = source.getConnection();
                    try {
                        connection.killCursor(cur.namespace, Collections.singletonList(cur.serverCursor.getId()));
                    }
                    finally {
                        connection.release();
                    }
                }
                finally {
                    source.release();
                }
            }
            finally {
                binding.release();
            }
        }
    }

    private static ClusterConnectionMode getSingleServerClusterMode(MongoClientOptions options) {
        if (options.getRequiredReplicaSetName() == null) {
            return ClusterConnectionMode.SINGLE;
        }
        return ClusterConnectionMode.MULTIPLE;
    }

    public static class Holder {
        private static final Holder INSTANCE = new Holder();
        private final ConcurrentMap<String, Mongo> clients = new ConcurrentHashMap<String, Mongo>();

        public static Holder singleton() {
            return INSTANCE;
        }

        @Deprecated
        public Mongo connect(MongoURI uri) {
            return this.connect(uri.toClientURI());
        }

        public Mongo connect(MongoClientURI uri) {
            String key = this.toKey(uri);
            Mongo client = (Mongo)this.clients.get(key);
            if (client == null) {
                MongoClient newbie = new MongoClient(uri);
                client = this.clients.putIfAbsent(key, newbie);
                if (client == null) {
                    client = newbie;
                } else {
                    newbie.close();
                }
            }
            return client;
        }

        private String toKey(MongoClientURI uri) {
            return uri.toString();
        }
    }

    private static class ServerCursorAndNamespace {
        private final ServerCursor serverCursor;
        private final MongoNamespace namespace;

        ServerCursorAndNamespace(ServerCursor serverCursor, MongoNamespace namespace) {
            this.serverCursor = serverCursor;
            this.namespace = namespace;
        }
    }
}

