/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver;

import java.util.Collection;
import java.util.Iterator;
import me.lucko.helper.mongo.external.mongodriver.Block;
import me.lucko.helper.mongo.external.mongodriver.Function;
import me.lucko.helper.mongo.external.mongodriver.MongoMappingCursor;
import me.lucko.helper.mongo.external.mongodriver.client.MongoCursor;
import me.lucko.helper.mongo.external.mongodriver.client.MongoIterable;

class MappingIterable<U, V>
implements MongoIterable<V> {
    private final MongoIterable<U> iterable;
    private final Function<U, V> mapper;

    MappingIterable(MongoIterable<U> iterable, Function<U, V> mapper) {
        this.iterable = iterable;
        this.mapper = mapper;
    }

    @Override
    public MongoCursor<V> iterator() {
        return new MongoMappingCursor<U, V>(this.iterable.iterator(), this.mapper);
    }

    @Override
    public V first() {
        Iterator iterator = this.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        return (V)iterator.next();
    }

    @Override
    public void forEach(final Block<? super V> block) {
        this.iterable.forEach(new Block<U>(){

            @Override
            public void apply(U document) {
                block.apply(MappingIterable.this.mapper.apply(document));
            }
        });
    }

    @Override
    public <A extends Collection<? super V>> A into(final A target) {
        this.forEach(new Block<V>(){

            @Override
            public void apply(V v) {
                target.add(v);
            }
        });
        return target;
    }

    public MappingIterable<U, V> batchSize(int batchSize) {
        this.iterable.batchSize(batchSize);
        return this;
    }

    @Override
    public <W> MongoIterable<W> map(Function<V, W> newMap) {
        return new MappingIterable<V, W>(this, newMap);
    }
}

