/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonJavaScript;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecRegistry;
import me.lucko.helper.mongo.external.bson.conversions.Bson;
import me.lucko.helper.mongo.external.mongodriver.Block;
import me.lucko.helper.mongo.external.mongodriver.FindIterableImpl;
import me.lucko.helper.mongo.external.mongodriver.Function;
import me.lucko.helper.mongo.external.mongodriver.MappingIterable;
import me.lucko.helper.mongo.external.mongodriver.MongoNamespace;
import me.lucko.helper.mongo.external.mongodriver.OperationIterable;
import me.lucko.helper.mongo.external.mongodriver.ReadConcern;
import me.lucko.helper.mongo.external.mongodriver.ReadPreference;
import me.lucko.helper.mongo.external.mongodriver.WriteConcern;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.client.MapReduceIterable;
import me.lucko.helper.mongo.external.mongodriver.client.MongoCursor;
import me.lucko.helper.mongo.external.mongodriver.client.MongoIterable;
import me.lucko.helper.mongo.external.mongodriver.client.model.Collation;
import me.lucko.helper.mongo.external.mongodriver.client.model.FindOptions;
import me.lucko.helper.mongo.external.mongodriver.client.model.MapReduceAction;
import me.lucko.helper.mongo.external.mongodriver.operation.MapReduceToCollectionOperation;
import me.lucko.helper.mongo.external.mongodriver.operation.MapReduceWithInlineResultsOperation;
import me.lucko.helper.mongo.external.mongodriver.operation.OperationExecutor;

class MapReduceIterableImpl<TDocument, TResult>
implements MapReduceIterable<TResult> {
    private final MongoNamespace namespace;
    private final Class<TDocument> documentClass;
    private final Class<TResult> resultClass;
    private final ReadPreference readPreference;
    private final ReadConcern readConcern;
    private final CodecRegistry codecRegistry;
    private final WriteConcern writeConcern;
    private final OperationExecutor executor;
    private final String mapFunction;
    private final String reduceFunction;
    private boolean inline = true;
    private String collectionName;
    private String finalizeFunction;
    private Bson scope;
    private Bson filter;
    private Bson sort;
    private int limit;
    private boolean jsMode;
    private boolean verbose = true;
    private long maxTimeMS;
    private MapReduceAction action = MapReduceAction.REPLACE;
    private String databaseName;
    private boolean sharded;
    private boolean nonAtomic;
    private int batchSize;
    private Boolean bypassDocumentValidation;
    private Collation collation;

    MapReduceIterableImpl(MongoNamespace namespace, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, OperationExecutor executor, String mapFunction, String reduceFunction) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.documentClass = Assertions.notNull("documentClass", documentClass);
        this.resultClass = Assertions.notNull("resultClass", resultClass);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.executor = Assertions.notNull("executor", executor);
        this.mapFunction = Assertions.notNull("mapFunction", mapFunction);
        this.reduceFunction = Assertions.notNull("reduceFunction", reduceFunction);
    }

    @Override
    public void toCollection() {
        if (this.inline) {
            throw new IllegalStateException("The options must specify a non-inline result");
        }
        this.executor.execute(this.createMapReduceToCollectionOperation());
    }

    @Override
    public MapReduceIterable<TResult> collectionName(String collectionName) {
        this.collectionName = Assertions.notNull("collectionName", collectionName);
        this.inline = false;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> finalizeFunction(String finalizeFunction) {
        this.finalizeFunction = finalizeFunction;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> scope(Bson scope) {
        this.scope = scope;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> sort(Bson sort) {
        this.sort = sort;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> filter(Bson filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> limit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> jsMode(boolean jsMode) {
        this.jsMode = jsMode;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public MapReduceIterable<TResult> action(MapReduceAction action) {
        this.action = action;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> databaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> sharded(boolean sharded) {
        this.sharded = sharded;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> nonAtomic(boolean nonAtomic) {
        this.nonAtomic = nonAtomic;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> bypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Override
    public MapReduceIterable<TResult> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public MongoCursor<TResult> iterator() {
        return this.execute().iterator();
    }

    @Override
    public TResult first() {
        return this.execute().first();
    }

    @Override
    public <U> MongoIterable<U> map(Function<TResult, U> mapper) {
        return new MappingIterable<TResult, U>(this, mapper);
    }

    @Override
    public void forEach(Block<? super TResult> block) {
        this.execute().forEach(block);
    }

    @Override
    public <A extends Collection<? super TResult>> A into(A target) {
        return this.execute().into(target);
    }

    MongoIterable<TResult> execute() {
        if (this.inline) {
            MapReduceWithInlineResultsOperation<TResult> operation = new MapReduceWithInlineResultsOperation<TResult>(this.namespace, new BsonJavaScript(this.mapFunction), new BsonJavaScript(this.reduceFunction), this.codecRegistry.get(this.resultClass)).filter(this.toBsonDocument(this.filter)).limit(this.limit).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS).jsMode(this.jsMode).scope(this.toBsonDocument(this.scope)).sort(this.toBsonDocument(this.sort)).verbose(this.verbose).readConcern(this.readConcern).collation(this.collation);
            if (this.finalizeFunction != null) {
                operation.finalizeFunction(new BsonJavaScript(this.finalizeFunction));
            }
            return new OperationIterable(operation, this.readPreference, this.executor);
        }
        this.executor.execute(this.createMapReduceToCollectionOperation());
        String dbName = this.databaseName != null ? this.databaseName : this.namespace.getDatabaseName();
        return new FindIterableImpl<TDocument, TResult>(new MongoNamespace(dbName, this.collectionName), this.documentClass, this.resultClass, this.codecRegistry, ReadPreference.primary(), this.readConcern, this.executor, new BsonDocument(), new FindOptions().collation(this.collation).batchSize(this.batchSize));
    }

    private MapReduceToCollectionOperation createMapReduceToCollectionOperation() {
        MapReduceToCollectionOperation operation = new MapReduceToCollectionOperation(this.namespace, new BsonJavaScript(this.mapFunction), new BsonJavaScript(this.reduceFunction), this.collectionName, this.writeConcern).filter(this.toBsonDocument(this.filter)).limit(this.limit).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS).jsMode(this.jsMode).scope(this.toBsonDocument(this.scope)).sort(this.toBsonDocument(this.sort)).verbose(this.verbose).action(this.action.getValue()).nonAtomic(this.nonAtomic).sharded(this.sharded).databaseName(this.databaseName).bypassDocumentValidation(this.bypassDocumentValidation).collation(this.collation);
        if (this.finalizeFunction != null) {
            operation.finalizeFunction(new BsonJavaScript(this.finalizeFunction));
        }
        return operation;
    }

    private BsonDocument toBsonDocument(Bson document) {
        return document == null ? null : document.toBsonDocument(this.documentClass, this.codecRegistry);
    }
}

