/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecRegistry;
import me.lucko.helper.mongo.external.mongodriver.Block;
import me.lucko.helper.mongo.external.mongodriver.Function;
import me.lucko.helper.mongo.external.mongodriver.MappingIterable;
import me.lucko.helper.mongo.external.mongodriver.OperationIterable;
import me.lucko.helper.mongo.external.mongodriver.ReadPreference;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.client.ListDatabasesIterable;
import me.lucko.helper.mongo.external.mongodriver.client.MongoCursor;
import me.lucko.helper.mongo.external.mongodriver.client.MongoIterable;
import me.lucko.helper.mongo.external.mongodriver.operation.ListDatabasesOperation;
import me.lucko.helper.mongo.external.mongodriver.operation.OperationExecutor;

final class ListDatabasesIterableImpl<TResult>
implements ListDatabasesIterable<TResult> {
    private final Class<TResult> resultClass;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final OperationExecutor executor;
    private long maxTimeMS;

    ListDatabasesIterableImpl(Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, OperationExecutor executor) {
        this.resultClass = Assertions.notNull("clazz", resultClass);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.executor = Assertions.notNull("executor", executor);
    }

    @Override
    public ListDatabasesIterableImpl<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public MongoCursor<TResult> iterator() {
        return this.execute().iterator();
    }

    @Override
    public TResult first() {
        return this.execute().first();
    }

    @Override
    public <U> MongoIterable<U> map(Function<TResult, U> mapper) {
        return new MappingIterable<TResult, U>(this, mapper);
    }

    @Override
    public void forEach(Block<? super TResult> block) {
        this.execute().forEach(block);
    }

    @Override
    public <A extends Collection<? super TResult>> A into(A target) {
        return this.execute().into(target);
    }

    @Override
    public ListDatabasesIterable<TResult> batchSize(int batchSize) {
        return this;
    }

    private MongoIterable<TResult> execute() {
        return new OperationIterable(this.createListCollectionsOperation(), this.readPreference, this.executor);
    }

    private ListDatabasesOperation<TResult> createListCollectionsOperation() {
        return new ListDatabasesOperation<TResult>(this.codecRegistry.get(this.resultClass)).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }
}

