/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver;

import java.io.IOException;
import me.lucko.helper.mongo.external.bson.BSONObject;
import me.lucko.helper.mongo.external.bson.io.OutputBuffer;
import me.lucko.helper.mongo.external.mongodriver.DBEncoder;
import me.lucko.helper.mongo.external.mongodriver.LazyDBObject;
import me.lucko.helper.mongo.external.mongodriver.MongoException;

public class LazyDBEncoder
implements DBEncoder {
    @Override
    public int writeObject(OutputBuffer outputBuffer, BSONObject document) {
        if (!(document instanceof LazyDBObject)) {
            throw new IllegalArgumentException("LazyDBEncoder can only encode BSONObject instances of type LazyDBObject");
        }
        LazyDBObject lazyDBObject = (LazyDBObject)document;
        try {
            return lazyDBObject.pipe(outputBuffer);
        }
        catch (IOException e) {
            throw new MongoException("Exception serializing a LazyDBObject", e);
        }
    }
}

