/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import me.lucko.helper.mongo.external.bson.BSONObject;
import me.lucko.helper.mongo.external.bson.BasicBSONCallback;
import me.lucko.helper.mongo.external.bson.types.BasicBSONList;
import me.lucko.helper.mongo.external.bson.types.ObjectId;
import me.lucko.helper.mongo.external.mongodriver.BasicDBList;
import me.lucko.helper.mongo.external.mongodriver.DBCallback;
import me.lucko.helper.mongo.external.mongodriver.DBCallbackFactory;
import me.lucko.helper.mongo.external.mongodriver.DBCollection;
import me.lucko.helper.mongo.external.mongodriver.DBCollectionObjectFactory;
import me.lucko.helper.mongo.external.mongodriver.DBObjectFactory;
import me.lucko.helper.mongo.external.mongodriver.DBRef;

public class DefaultDBCallback
extends BasicBSONCallback
implements DBCallback {
    private final DBObjectFactory objectFactory;
    public static final DBCallbackFactory FACTORY = new DBCallbackFactory(){

        @Override
        public DBCallback create(DBCollection collection) {
            return new DefaultDBCallback(collection);
        }
    };

    public DefaultDBCallback(DBCollection collection) {
        this.objectFactory = collection != null ? collection.getObjectFactory() : new DBCollectionObjectFactory();
    }

    @Override
    public BSONObject create() {
        return this.objectFactory.getInstance();
    }

    @Override
    public BSONObject create(boolean array, List<String> path) {
        return array ? new BasicDBList() : this.objectFactory.getInstance(path != null ? path : Collections.emptyList());
    }

    @Override
    public void gotDBRef(String name, String namespace, ObjectId id) {
        this._put(name, new DBRef(namespace, id));
    }

    @Override
    public Object objectDone() {
        Iterator<String> iterator;
        String name = this.curName();
        BSONObject document = (BSONObject)super.objectDone();
        if (!(document instanceof BasicBSONList) && (iterator = document.keySet().iterator()).hasNext() && iterator.next().equals("$ref") && iterator.hasNext() && iterator.next().equals("$id")) {
            this._put(name, new DBRef((String)document.get("$db"), (String)document.get("$ref"), document.get("$id")));
        }
        return document;
    }
}

