/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver;

import java.util.Date;
import java.util.List;
import me.lucko.helper.mongo.external.bson.codecs.BsonTypeClassMap;
import me.lucko.helper.mongo.external.bson.codecs.Codec;
import me.lucko.helper.mongo.external.bson.codecs.DateCodec;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecProvider;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecRegistry;
import me.lucko.helper.mongo.external.bson.types.BSONTimestamp;
import me.lucko.helper.mongo.external.mongodriver.BSONTimestampCodec;
import me.lucko.helper.mongo.external.mongodriver.DBObject;
import me.lucko.helper.mongo.external.mongodriver.DBObjectCodec;

public class DBObjectCodecProvider
implements CodecProvider {
    private final BsonTypeClassMap bsonTypeClassMap;

    public DBObjectCodecProvider() {
        this(DBObjectCodec.getDefaultBsonTypeClassMap());
    }

    public DBObjectCodecProvider(BsonTypeClassMap bsonTypeClassMap) {
        this.bsonTypeClassMap = bsonTypeClassMap;
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (clazz == BSONTimestamp.class) {
            return new BSONTimestampCodec();
        }
        if (DBObject.class.isAssignableFrom(clazz) && !List.class.isAssignableFrom(clazz)) {
            return new DBObjectCodec(registry, this.bsonTypeClassMap);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return new DateCodec();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

