/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver;

import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.mongodriver.BasicDBObject;
import me.lucko.helper.mongo.external.mongodriver.DBObjects;
import me.lucko.helper.mongo.external.mongodriver.MongoCommandException;
import me.lucko.helper.mongo.external.mongodriver.MongoException;
import me.lucko.helper.mongo.external.mongodriver.ServerAddress;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;

public class CommandResult
extends BasicDBObject {
    private static final long serialVersionUID = 5907909423864204060L;
    private final BsonDocument response;
    private final ServerAddress address;

    CommandResult(BsonDocument response) {
        this(response, null);
    }

    CommandResult(BsonDocument response, ServerAddress address) {
        this.address = address;
        this.response = Assertions.notNull("response", response);
        this.putAll(DBObjects.toDBObject(response));
    }

    public boolean ok() {
        Object okValue = this.get("ok");
        if (okValue instanceof Boolean) {
            return (Boolean)okValue;
        }
        if (okValue instanceof Number) {
            return ((Number)okValue).intValue() == 1;
        }
        return false;
    }

    public String getErrorMessage() {
        Object foo = this.get("errmsg");
        if (foo == null) {
            return null;
        }
        return foo.toString();
    }

    public MongoException getException() {
        if (!this.ok()) {
            return new MongoCommandException(this.response, this.address);
        }
        return null;
    }

    public void throwOnError() {
        if (!this.ok()) {
            throw this.getException();
        }
    }
}

