/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver;

import me.lucko.helper.mongo.external.bson.codecs.Encoder;
import me.lucko.helper.mongo.external.mongodriver.BulkUpdateRequestBuilder;
import me.lucko.helper.mongo.external.mongodriver.BulkWriteOperation;
import me.lucko.helper.mongo.external.mongodriver.DBObject;
import me.lucko.helper.mongo.external.mongodriver.RemoveRequest;
import me.lucko.helper.mongo.external.mongodriver.client.model.Collation;

public class BulkWriteRequestBuilder {
    private final BulkWriteOperation bulkWriteOperation;
    private final DBObject query;
    private final Encoder<DBObject> codec;
    private final Encoder<DBObject> replacementCodec;
    private Collation collation;

    BulkWriteRequestBuilder(BulkWriteOperation bulkWriteOperation, DBObject query, Encoder<DBObject> queryCodec, Encoder<DBObject> replacementCodec) {
        this.bulkWriteOperation = bulkWriteOperation;
        this.query = query;
        this.codec = queryCodec;
        this.replacementCodec = replacementCodec;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public BulkWriteRequestBuilder collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    public void remove() {
        this.bulkWriteOperation.addRequest(new RemoveRequest(this.query, true, this.codec, this.collation));
    }

    public void removeOne() {
        this.bulkWriteOperation.addRequest(new RemoveRequest(this.query, false, this.codec, this.collation));
    }

    public void replaceOne(DBObject document) {
        new BulkUpdateRequestBuilder(this.bulkWriteOperation, this.query, false, this.codec, this.replacementCodec, this.collation).replaceOne(document);
    }

    public void update(DBObject update) {
        new BulkUpdateRequestBuilder(this.bulkWriteOperation, this.query, false, this.codec, this.replacementCodec, this.collation).update(update);
    }

    public void updateOne(DBObject update) {
        new BulkUpdateRequestBuilder(this.bulkWriteOperation, this.query, false, this.codec, this.replacementCodec, this.collation).updateOne(update);
    }

    public BulkUpdateRequestBuilder upsert() {
        return new BulkUpdateRequestBuilder(this.bulkWriteOperation, this.query, true, this.codec, this.replacementCodec, this.collation);
    }
}

