/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver;

import me.lucko.helper.mongo.external.bson.codecs.Encoder;
import me.lucko.helper.mongo.external.mongodriver.BulkWriteOperation;
import me.lucko.helper.mongo.external.mongodriver.DBObject;
import me.lucko.helper.mongo.external.mongodriver.ReplaceRequest;
import me.lucko.helper.mongo.external.mongodriver.UpdateRequest;
import me.lucko.helper.mongo.external.mongodriver.client.model.Collation;

public class BulkUpdateRequestBuilder {
    private final BulkWriteOperation bulkWriteOperation;
    private final DBObject query;
    private final boolean upsert;
    private final Encoder<DBObject> queryCodec;
    private final Encoder<DBObject> replacementCodec;
    private Collation collation;

    BulkUpdateRequestBuilder(BulkWriteOperation bulkWriteOperation, DBObject query, boolean upsert, Encoder<DBObject> queryCodec, Encoder<DBObject> replacementCodec, Collation collation) {
        this.bulkWriteOperation = bulkWriteOperation;
        this.query = query;
        this.upsert = upsert;
        this.queryCodec = queryCodec;
        this.replacementCodec = replacementCodec;
        this.collation = collation;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public BulkUpdateRequestBuilder collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    public void replaceOne(DBObject document) {
        this.bulkWriteOperation.addRequest(new ReplaceRequest(this.query, document, this.upsert, this.queryCodec, this.replacementCodec, this.collation));
    }

    public void update(DBObject update) {
        this.bulkWriteOperation.addRequest(new UpdateRequest(this.query, update, true, this.upsert, this.queryCodec, this.collation));
    }

    public void updateOne(DBObject update) {
        this.bulkWriteOperation.addRequest(new UpdateRequest(this.query, update, false, this.upsert, this.queryCodec, this.collation));
    }
}

