/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.bson.json;

import me.lucko.helper.mongo.external.bson.json.Converter;
import me.lucko.helper.mongo.external.bson.json.ExtendedJsonDoubleConverter;
import me.lucko.helper.mongo.external.bson.json.StrictJsonWriter;

class RelaxedExtendedJsonDoubleConverter
implements Converter<Double> {
    private static final Converter<Double> FALLBACK_CONVERTER = new ExtendedJsonDoubleConverter();

    RelaxedExtendedJsonDoubleConverter() {
    }

    @Override
    public void convert(Double value, StrictJsonWriter writer) {
        if (value.isNaN() || value.isInfinite()) {
            FALLBACK_CONVERTER.convert(value, writer);
        } else {
            writer.writeNumber(Double.toString(value));
        }
    }
}

