/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.bson.json;

import me.lucko.helper.mongo.external.bson.BsonTimestamp;
import me.lucko.helper.mongo.external.bson.internal.UnsignedLongs;
import me.lucko.helper.mongo.external.bson.json.Converter;
import me.lucko.helper.mongo.external.bson.json.StrictJsonWriter;

class ExtendedJsonTimestampConverter
implements Converter<BsonTimestamp> {
    ExtendedJsonTimestampConverter() {
    }

    @Override
    public void convert(BsonTimestamp value, StrictJsonWriter writer) {
        writer.writeStartObject();
        writer.writeStartObject("$timestamp");
        writer.writeNumber("t", UnsignedLongs.toString(this.toUnsignedLong(value.getTime())));
        writer.writeNumber("i", UnsignedLongs.toString(this.toUnsignedLong(value.getInc())));
        writer.writeEndObject();
        writer.writeEndObject();
    }

    private long toUnsignedLong(int value) {
        return (long)value & 0xFFFFFFFFL;
    }
}

