/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.bson.diagnostics;

import me.lucko.helper.mongo.external.bson.assertions.Assertions;
import me.lucko.helper.mongo.external.bson.diagnostics.JULLogger;
import me.lucko.helper.mongo.external.bson.diagnostics.Logger;
import me.lucko.helper.mongo.external.bson.diagnostics.SLF4JLogger;

public final class Loggers {
    public static final String PREFIX = "me.lucko.helper.mongo.external.bson";
    private static final boolean USE_SLF4J = Loggers.shouldUseSLF4J();

    public static Logger getLogger(String suffix) {
        Assertions.notNull("suffix", suffix);
        if (suffix.startsWith(".") || suffix.endsWith(".")) {
            throw new IllegalArgumentException("The suffix can not start or end with a '.'");
        }
        String name = "me.lucko.helper.mongo.external.bson." + suffix;
        if (USE_SLF4J) {
            return new SLF4JLogger(name);
        }
        return new JULLogger(name);
    }

    private static boolean shouldUseSLF4J() {
        try {
            Class.forName("org.slf4j.LoggerFactory");
            Class.forName("org.slf4j.impl.StaticLoggerBinder");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private Loggers() {
    }
}

