/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.bson.codecs.pojo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.lucko.helper.mongo.external.bson.assertions.Assertions;

final class TypeData<T> {
    private final Class<T> type;
    private final List<TypeData<?>> typeParameters;
    private static final Map<Class<?>, Class<?>> PRIMITIVE_CLASS_MAP;

    public static <T> Builder<T> builder(Class<T> type) {
        return new Builder(Assertions.notNull("type", type));
    }

    public Class<T> getType() {
        return this.type;
    }

    public List<TypeData<?>> getTypeParameters() {
        return this.typeParameters;
    }

    public String toString() {
        String typeParams = this.typeParameters.isEmpty() ? "" : ", typeParameters=[" + TypeData.nestedTypeParameters(this.typeParameters) + "]";
        return "TypeData{type=" + this.type.getSimpleName() + typeParams + "}";
    }

    private static String nestedTypeParameters(List<TypeData<?>> typeParameters) {
        StringBuilder builder = new StringBuilder();
        int count = 0;
        int last = typeParameters.size();
        for (TypeData<?> typeParameter : typeParameters) {
            ++count;
            builder.append(typeParameter.getType().getSimpleName());
            if (!typeParameter.getTypeParameters().isEmpty()) {
                builder.append(String.format("<%s>", TypeData.nestedTypeParameters(typeParameter.getTypeParameters())));
            }
            if (count >= last) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeData)) {
            return false;
        }
        TypeData that = (TypeData)o;
        if (!this.getType().equals(that.getType())) {
            return false;
        }
        return this.getTypeParameters().equals(that.getTypeParameters());
    }

    public int hashCode() {
        int result = this.getType().hashCode();
        result = 31 * result + this.getTypeParameters().hashCode();
        return result;
    }

    private TypeData(Class<T> type, List<TypeData<?>> typeParameters) {
        this.type = this.getClass(type);
        this.typeParameters = typeParameters;
    }

    private Class<T> getClass(Class<T> type) {
        Class<Object> instanceType = this.boxType(type);
        if (type.equals(Map.class)) {
            instanceType = HashMap.class;
        } else if (type.equals(List.class) || type.equals(Collection.class)) {
            instanceType = ArrayList.class;
        } else if (type.equals(Set.class)) {
            instanceType = HashSet.class;
        }
        return instanceType;
    }

    private Class<T> boxType(Class<T> clazz) {
        if (clazz.isPrimitive()) {
            return PRIMITIVE_CLASS_MAP.get(clazz);
        }
        return clazz;
    }

    static {
        HashMap map = new HashMap();
        map.put(Boolean.TYPE, Boolean.class);
        map.put(Byte.TYPE, Byte.class);
        map.put(Character.TYPE, Character.class);
        map.put(Double.TYPE, Double.class);
        map.put(Float.TYPE, Float.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Long.TYPE, Long.class);
        map.put(Short.TYPE, Short.class);
        PRIMITIVE_CLASS_MAP = map;
    }

    public static final class Builder<T> {
        private final Class<T> type;
        private final List<TypeData<?>> typeParameters = new ArrayList();

        private Builder(Class<T> type) {
            this.type = type;
        }

        public <S> Builder<T> addTypeParameter(TypeData<S> typeParameter) {
            this.typeParameters.add(Assertions.notNull("typeParameter", typeParameter));
            return this;
        }

        public Builder<T> addTypeParameters(List<TypeData<?>> typeParameters) {
            Assertions.notNull("typeParameters", typeParameters);
            for (TypeData<?> typeParameter : typeParameters) {
                this.addTypeParameter(typeParameter);
            }
            return this;
        }

        public TypeData<T> build() {
            this.validate();
            return new TypeData(this.type, Collections.unmodifiableList(this.typeParameters));
        }

        private void validate() {
            if (Collection.class.isAssignableFrom(this.type)) {
                if (this.typeParameters.size() != 1) {
                    throw new IllegalStateException("Invalid Collection type. Collections must have a single type parameter defined.");
                }
            } else if (Map.class.isAssignableFrom(this.type)) {
                if (this.typeParameters.size() != 2) {
                    throw new IllegalStateException("Invalid Map type. Map must have two type parameters defined.");
                }
                if (this.typeParameters.get(0).getType() != String.class) {
                    throw new IllegalStateException(String.format("Invalid Map type. Maps MUST have string keys, found %s instead.", this.typeParameters.get(0).getType()));
                }
            }
        }
    }
}

