/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.bson.codecs.pojo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.lucko.helper.mongo.external.bson.assertions.Assertions;
import me.lucko.helper.mongo.external.bson.codecs.Codec;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecProvider;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecRegistry;
import me.lucko.helper.mongo.external.bson.codecs.pojo.AutomaticPojoCodec;
import me.lucko.helper.mongo.external.bson.codecs.pojo.ClassModel;
import me.lucko.helper.mongo.external.bson.codecs.pojo.ClassModelBuilder;
import me.lucko.helper.mongo.external.bson.codecs.pojo.Convention;
import me.lucko.helper.mongo.external.bson.codecs.pojo.DiscriminatorLookup;
import me.lucko.helper.mongo.external.bson.codecs.pojo.PojoCodec;
import me.lucko.helper.mongo.external.bson.codecs.pojo.PojoCodecImpl;

public final class PojoCodecProvider
implements CodecProvider {
    private final boolean automatic;
    private final Map<Class<?>, ClassModel<?>> classModels;
    private final Set<String> packages;
    private final List<Convention> conventions;
    private final DiscriminatorLookup discriminatorLookup;

    private PojoCodecProvider(boolean automatic, Map<Class<?>, ClassModel<?>> classModels, Set<String> packages, List<Convention> conventions) {
        this.automatic = automatic;
        this.classModels = classModels;
        this.packages = packages;
        this.conventions = conventions;
        this.discriminatorLookup = new DiscriminatorLookup(classModels, packages);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        return this.getPojoCodec(clazz, registry);
    }

    <T> PojoCodec<T> getPojoCodec(Class<T> clazz, CodecRegistry registry) {
        ClassModel<Object> classModel = this.classModels.get(clazz);
        if (classModel != null || clazz.getPackage() != null && this.packages.contains(clazz.getPackage().getName())) {
            if (classModel == null) {
                classModel = PojoCodecProvider.createClassModel(clazz, this.conventions);
                this.discriminatorLookup.addClassModel(classModel);
            }
            return new PojoCodecImpl(classModel, registry, this.discriminatorLookup);
        }
        if (this.automatic) {
            try {
                classModel = PojoCodecProvider.createClassModel(clazz, this.conventions);
            }
            catch (IllegalStateException e) {
                return null;
            }
            if (!clazz.isInterface() && classModel.getPropertyModels().isEmpty()) {
                return null;
            }
            this.discriminatorLookup.addClassModel(classModel);
            return new AutomaticPojoCodec<Object>(new PojoCodecImpl<Object>(classModel, registry, this.discriminatorLookup));
        }
        return null;
    }

    private static <T> ClassModel<T> createClassModel(Class<T> clazz, List<Convention> conventions) {
        ClassModelBuilder<T> builder = ClassModel.builder(clazz);
        if (conventions != null) {
            builder.conventions(conventions);
        }
        return builder.build();
    }

    public static final class Builder {
        private final Set<String> packages = new HashSet<String>();
        private final Map<Class<?>, ClassModel<?>> classModels = new HashMap();
        private final List<Class<?>> clazzes = new ArrayList();
        private List<Convention> conventions = null;
        private boolean automatic;

        public PojoCodecProvider build() {
            List<Convention> immutableConventions = this.conventions != null ? Collections.unmodifiableList(new ArrayList<Convention>(this.conventions)) : null;
            for (Class<?> clazz : this.clazzes) {
                if (this.classModels.containsKey(clazz)) continue;
                this.register(PojoCodecProvider.createClassModel(clazz, immutableConventions));
            }
            return new PojoCodecProvider(this.automatic, this.classModels, this.packages, immutableConventions);
        }

        public Builder automatic(boolean automatic) {
            this.automatic = automatic;
            return this;
        }

        public Builder conventions(List<Convention> conventions) {
            this.conventions = Assertions.notNull("conventions", conventions);
            return this;
        }

        public Builder register(Class<?> ... classes) {
            this.clazzes.addAll(Arrays.asList(classes));
            return this;
        }

        public Builder register(ClassModel<?> ... classModels) {
            Assertions.notNull("classModels", classModels);
            for (ClassModel<?> classModel : classModels) {
                this.classModels.put(classModel.getType(), classModel);
            }
            return this;
        }

        public Builder register(String ... packageNames) {
            this.packages.addAll(Arrays.asList((Object[])Assertions.notNull("packageNames", packageNames)));
            return this;
        }

        private Builder() {
        }
    }
}

