/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.bson.codecs.pojo;

import java.util.Map;
import me.lucko.helper.mongo.external.bson.BsonReader;
import me.lucko.helper.mongo.external.bson.BsonType;
import me.lucko.helper.mongo.external.bson.BsonWriter;
import me.lucko.helper.mongo.external.bson.codecs.Codec;
import me.lucko.helper.mongo.external.bson.codecs.DecoderContext;
import me.lucko.helper.mongo.external.bson.codecs.EncoderContext;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecConfigurationException;

final class MapCodec<T>
implements Codec<Map<String, T>> {
    private final Class<Map<String, T>> encoderClass;
    private final Codec<T> codec;

    MapCodec(Class<Map<String, T>> encoderClass, Codec<T> codec) {
        this.encoderClass = encoderClass;
        this.codec = codec;
    }

    @Override
    public void encode(BsonWriter writer, Map<String, T> map, EncoderContext encoderContext) {
        writer.writeStartDocument();
        for (Map.Entry<String, T> entry : map.entrySet()) {
            writer.writeName(entry.getKey());
            this.codec.encode(writer, entry.getValue(), encoderContext);
        }
        writer.writeEndDocument();
    }

    @Override
    public Map<String, T> decode(BsonReader reader, DecoderContext context) {
        reader.readStartDocument();
        Map<String, T> map = this.getInstance();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            map.put(reader.readName(), this.codec.decode(reader, context));
        }
        reader.readEndDocument();
        return map;
    }

    @Override
    public Class<Map<String, T>> getEncoderClass() {
        return this.encoderClass;
    }

    private Map<String, T> getInstance() {
        try {
            return this.encoderClass.newInstance();
        }
        catch (Exception e) {
            throw new CodecConfigurationException(e.getMessage(), e);
        }
    }
}

