/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.bson.codecs.pojo;

import java.util.HashMap;
import java.util.Map;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecConfigurationException;
import me.lucko.helper.mongo.external.bson.codecs.pojo.CreatorExecutable;
import me.lucko.helper.mongo.external.bson.codecs.pojo.InstanceCreator;
import me.lucko.helper.mongo.external.bson.codecs.pojo.PropertyModel;

final class InstanceCreatorImpl<T>
implements InstanceCreator<T> {
    private final CreatorExecutable<T> creatorExecutable;
    private final Map<PropertyModel<?>, Object> cachedValues;
    private final Map<String, Integer> properties;
    private final Object[] params;
    private T newInstance;

    InstanceCreatorImpl(CreatorExecutable<T> creatorExecutable) {
        this.creatorExecutable = creatorExecutable;
        if (creatorExecutable.getProperties().isEmpty()) {
            this.cachedValues = null;
            this.properties = null;
            this.params = null;
            this.newInstance = creatorExecutable.getInstance();
        } else {
            this.cachedValues = new HashMap();
            this.properties = new HashMap<String, Integer>();
            for (int i = 0; i < creatorExecutable.getProperties().size(); ++i) {
                this.properties.put(creatorExecutable.getProperties().get(i).value(), i);
            }
            this.params = new Object[this.properties.size()];
        }
    }

    @Override
    public <S> void set(S value, PropertyModel<S> propertyModel) {
        if (this.newInstance != null) {
            propertyModel.getPropertyAccessor().set(this.newInstance, value);
        } else {
            if (!this.properties.isEmpty()) {
                Integer index = this.properties.get(propertyModel.getName());
                if (index != null) {
                    this.params[index.intValue()] = value;
                }
                this.properties.remove(propertyModel.getName());
            }
            if (this.properties.isEmpty()) {
                this.constructInstanceAndProcessCachedValues();
            } else {
                this.cachedValues.put(propertyModel, value);
            }
        }
    }

    @Override
    public T getInstance() {
        if (this.newInstance == null) {
            throw new CodecConfigurationException(String.format("Could not construct new instance of: %s. Missing the following properties: %s", this.creatorExecutable.getType().getSimpleName(), this.properties.keySet()));
        }
        return this.newInstance;
    }

    private void constructInstanceAndProcessCachedValues() {
        try {
            this.newInstance = this.creatorExecutable.getInstance(this.params);
        }
        catch (Exception e) {
            throw new CodecConfigurationException(e.getMessage(), e);
        }
        for (Map.Entry<PropertyModel<?>, Object> entry : this.cachedValues.entrySet()) {
            this.setPropertyValue(entry.getKey(), entry.getValue());
        }
    }

    private <S> void setPropertyValue(PropertyModel<S> propertyModel, Object value) {
        this.set(value, propertyModel);
    }
}

