/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.bson.codecs.pojo;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecConfigurationException;
import me.lucko.helper.mongo.external.bson.codecs.pojo.ClassModelBuilder;
import me.lucko.helper.mongo.external.bson.codecs.pojo.Convention;
import me.lucko.helper.mongo.external.bson.codecs.pojo.CreatorExecutable;
import me.lucko.helper.mongo.external.bson.codecs.pojo.InstanceCreatorFactoryImpl;
import me.lucko.helper.mongo.external.bson.codecs.pojo.PojoBuilderHelper;
import me.lucko.helper.mongo.external.bson.codecs.pojo.PropertyMetadata;
import me.lucko.helper.mongo.external.bson.codecs.pojo.PropertyModelBuilder;
import me.lucko.helper.mongo.external.bson.codecs.pojo.TypeData;
import me.lucko.helper.mongo.external.bson.codecs.pojo.annotations.BsonCreator;
import me.lucko.helper.mongo.external.bson.codecs.pojo.annotations.BsonDiscriminator;
import me.lucko.helper.mongo.external.bson.codecs.pojo.annotations.BsonId;
import me.lucko.helper.mongo.external.bson.codecs.pojo.annotations.BsonIgnore;
import me.lucko.helper.mongo.external.bson.codecs.pojo.annotations.BsonProperty;

final class ConventionAnnotationImpl
implements Convention {
    ConventionAnnotationImpl() {
    }

    @Override
    public void apply(ClassModelBuilder<?> classModelBuilder) {
        for (Annotation annotation : classModelBuilder.getAnnotations()) {
            this.processClassAnnotation(classModelBuilder, annotation);
        }
        for (PropertyModelBuilder propertyModelBuilder : classModelBuilder.getPropertyModelBuilders()) {
            this.processPropertyAnnotations(classModelBuilder, propertyModelBuilder);
        }
        this.processCreatorAnnotation(classModelBuilder);
        this.cleanPropertyBuilders(classModelBuilder);
    }

    private void processClassAnnotation(ClassModelBuilder<?> classModelBuilder, Annotation annotation) {
        if (annotation instanceof BsonDiscriminator) {
            String name;
            BsonDiscriminator discriminator = (BsonDiscriminator)annotation;
            String key = discriminator.key();
            if (!key.equals("")) {
                classModelBuilder.discriminatorKey(key);
            }
            if (!(name = discriminator.value()).equals("")) {
                classModelBuilder.discriminator(name);
            }
            classModelBuilder.enableDiscriminator(true);
        }
    }

    private void processPropertyAnnotations(ClassModelBuilder<?> classModelBuilder, PropertyModelBuilder<?> propertyModelBuilder) {
        BsonProperty bsonProperty;
        for (Annotation annotation : propertyModelBuilder.getReadAnnotations()) {
            if (annotation instanceof BsonProperty) {
                bsonProperty = (BsonProperty)annotation;
                if (!"".equals(bsonProperty.value())) {
                    propertyModelBuilder.readName(bsonProperty.value());
                }
                propertyModelBuilder.discriminatorEnabled(bsonProperty.useDiscriminator());
                continue;
            }
            if (annotation instanceof BsonId) {
                classModelBuilder.idPropertyName(propertyModelBuilder.getName());
                continue;
            }
            if (!(annotation instanceof BsonIgnore)) continue;
            propertyModelBuilder.readName(null);
        }
        for (Annotation annotation : propertyModelBuilder.getWriteAnnotations()) {
            if (annotation instanceof BsonProperty) {
                bsonProperty = (BsonProperty)annotation;
                if ("".equals(bsonProperty.value())) continue;
                propertyModelBuilder.writeName(bsonProperty.value());
                continue;
            }
            if (!(annotation instanceof BsonIgnore)) continue;
            propertyModelBuilder.writeName(null);
        }
    }

    private <T> void processCreatorAnnotation(ClassModelBuilder<T> classModelBuilder) {
        Class<T> clazz = classModelBuilder.getType();
        CreatorExecutable<T> creatorExecutable = null;
        block0: for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (!Modifier.isPublic(constructor.getModifiers())) continue;
            for (Annotation annotation : constructor.getDeclaredAnnotations()) {
                if (!annotation.annotationType().equals(BsonCreator.class)) continue;
                creatorExecutable = new CreatorExecutable<T>(clazz, constructor);
                continue block0;
            }
        }
        block2: for (Executable executable : clazz.getDeclaredMethods()) {
            if (!Modifier.isStatic(((Method)executable).getModifiers())) continue;
            for (Annotation annotation : ((Method)executable).getDeclaredAnnotations()) {
                if (!annotation.annotationType().equals(BsonCreator.class)) continue;
                if (creatorExecutable != null) {
                    throw new CodecConfigurationException("Found multiple constructors / methods annotated with @BsonCreator");
                }
                if (!clazz.isAssignableFrom(((Method)executable).getReturnType())) {
                    throw new CodecConfigurationException(String.format("Invalid method annotated with @BsonCreator. Returns '%s', expected %s", ((Method)executable).getReturnType(), clazz));
                }
                creatorExecutable = new CreatorExecutable<T>(clazz, (Method)executable);
                continue block2;
            }
        }
        if (creatorExecutable != null) {
            List<BsonProperty> properties = creatorExecutable.getProperties();
            List<Class<?>> parameterTypes = creatorExecutable.getParameterTypes();
            if (properties.size() != parameterTypes.size()) {
                throw creatorExecutable.getError("All parameters must be annotated with a @Property");
            }
            for (int i = 0; i < properties.size(); ++i) {
                BsonProperty bsonProperty = properties.get(i);
                Class<?> parameterType = parameterTypes.get(i);
                PropertyModelBuilder<?> propertyModelBuilder = classModelBuilder.getProperty(bsonProperty.value());
                if (propertyModelBuilder == null) {
                    this.addCreatorPropertyToClassModelBuilder(classModelBuilder, bsonProperty.value(), parameterType);
                    continue;
                }
                if (propertyModelBuilder.getTypeData().getType() == parameterType) continue;
                throw creatorExecutable.getError(String.format("Invalid Property type for '%s'. Expected %s, found %s.", bsonProperty.value(), propertyModelBuilder.getTypeData().getType(), parameterType));
            }
            classModelBuilder.instanceCreatorFactory(new InstanceCreatorFactoryImpl<T>(creatorExecutable));
        }
    }

    private <T, S> void addCreatorPropertyToClassModelBuilder(ClassModelBuilder<T> classModelBuilder, String name, Class<S> clazz) {
        classModelBuilder.addProperty(PojoBuilderHelper.createPropertyModelBuilder(new PropertyMetadata<S>(name, classModelBuilder.getType().getSimpleName(), TypeData.builder(clazz).build())).readName(null).writeName(name));
    }

    private void cleanPropertyBuilders(ClassModelBuilder<?> classModelBuilder) {
        ArrayList<String> propertiesToRemove = new ArrayList<String>();
        for (PropertyModelBuilder<?> propertyModelBuilder : classModelBuilder.getPropertyModelBuilders()) {
            if (propertyModelBuilder.isReadable() || propertyModelBuilder.isWritable()) continue;
            propertiesToRemove.add(propertyModelBuilder.getName());
        }
        for (String propertyName : propertiesToRemove) {
            classModelBuilder.removeProperty(propertyName);
        }
    }
}

