/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.bson.codecs.pojo;

import java.util.Collection;
import me.lucko.helper.mongo.external.bson.BsonReader;
import me.lucko.helper.mongo.external.bson.BsonType;
import me.lucko.helper.mongo.external.bson.BsonWriter;
import me.lucko.helper.mongo.external.bson.codecs.Codec;
import me.lucko.helper.mongo.external.bson.codecs.DecoderContext;
import me.lucko.helper.mongo.external.bson.codecs.EncoderContext;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecConfigurationException;

final class CollectionCodec<T>
implements Codec<Collection<T>> {
    private final Class<Collection<T>> encoderClass;
    private final Codec<T> codec;

    CollectionCodec(Class<Collection<T>> encoderClass, Codec<T> codec) {
        this.encoderClass = encoderClass;
        this.codec = codec;
    }

    @Override
    public void encode(BsonWriter writer, Collection<T> collection, EncoderContext encoderContext) {
        writer.writeStartArray();
        for (T value : collection) {
            this.codec.encode(writer, value, encoderContext);
        }
        writer.writeEndArray();
    }

    @Override
    public Collection<T> decode(BsonReader reader, DecoderContext context) {
        Collection<T> collection = this.getInstance();
        reader.readStartArray();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            collection.add(this.codec.decode(reader, context));
        }
        reader.readEndArray();
        return collection;
    }

    @Override
    public Class<Collection<T>> getEncoderClass() {
        return this.encoderClass;
    }

    private Collection<T> getInstance() {
        try {
            return this.encoderClass.newInstance();
        }
        catch (Exception e) {
            throw new CodecConfigurationException(e.getMessage(), e);
        }
    }
}

