/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.bson.codecs;

import me.lucko.helper.mongo.external.bson.BsonInvalidOperationException;
import me.lucko.helper.mongo.external.bson.BsonReader;
import me.lucko.helper.mongo.external.bson.BsonWriter;
import me.lucko.helper.mongo.external.bson.codecs.Codec;
import me.lucko.helper.mongo.external.bson.codecs.DecoderContext;
import me.lucko.helper.mongo.external.bson.codecs.EncoderContext;
import me.lucko.helper.mongo.external.bson.codecs.NumberCodecHelper;

public class ShortCodec
implements Codec<Short> {
    @Override
    public void encode(BsonWriter writer, Short value, EncoderContext encoderContext) {
        writer.writeInt32(value.shortValue());
    }

    @Override
    public Short decode(BsonReader reader, DecoderContext decoderContext) {
        int value = NumberCodecHelper.decodeInt(reader);
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new BsonInvalidOperationException(String.format("%s can not be converted into a Short.", value));
        }
        return (short)value;
    }

    @Override
    public Class<Short> getEncoderClass() {
        return Short.class;
    }
}

