/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.bson.codecs;

import me.lucko.helper.mongo.external.bson.BsonInvalidOperationException;
import me.lucko.helper.mongo.external.bson.BsonReader;
import me.lucko.helper.mongo.external.bson.BsonWriter;
import me.lucko.helper.mongo.external.bson.codecs.Codec;
import me.lucko.helper.mongo.external.bson.codecs.DecoderContext;
import me.lucko.helper.mongo.external.bson.codecs.EncoderContext;
import me.lucko.helper.mongo.external.bson.codecs.NumberCodecHelper;

public class FloatCodec
implements Codec<Float> {
    @Override
    public void encode(BsonWriter writer, Float value, EncoderContext encoderContext) {
        writer.writeDouble(value.floatValue());
    }

    @Override
    public Float decode(BsonReader reader, DecoderContext decoderContext) {
        double value = NumberCodecHelper.decodeDouble(reader);
        if (value < -3.4028234663852886E38 || value > 3.4028234663852886E38) {
            throw new BsonInvalidOperationException(String.format("%s can not be converted into a Float.", value));
        }
        return Float.valueOf((float)value);
    }

    @Override
    public Class<Float> getEncoderClass() {
        return Float.class;
    }
}

