/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.bson.codecs;

import java.util.HashMap;
import java.util.Map;
import me.lucko.helper.mongo.external.bson.BsonArray;
import me.lucko.helper.mongo.external.bson.BsonBinary;
import me.lucko.helper.mongo.external.bson.BsonBoolean;
import me.lucko.helper.mongo.external.bson.BsonDateTime;
import me.lucko.helper.mongo.external.bson.BsonDbPointer;
import me.lucko.helper.mongo.external.bson.BsonDecimal128;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonDocumentWrapper;
import me.lucko.helper.mongo.external.bson.BsonDouble;
import me.lucko.helper.mongo.external.bson.BsonInt32;
import me.lucko.helper.mongo.external.bson.BsonInt64;
import me.lucko.helper.mongo.external.bson.BsonJavaScript;
import me.lucko.helper.mongo.external.bson.BsonJavaScriptWithScope;
import me.lucko.helper.mongo.external.bson.BsonMaxKey;
import me.lucko.helper.mongo.external.bson.BsonMinKey;
import me.lucko.helper.mongo.external.bson.BsonNull;
import me.lucko.helper.mongo.external.bson.BsonObjectId;
import me.lucko.helper.mongo.external.bson.BsonRegularExpression;
import me.lucko.helper.mongo.external.bson.BsonString;
import me.lucko.helper.mongo.external.bson.BsonSymbol;
import me.lucko.helper.mongo.external.bson.BsonTimestamp;
import me.lucko.helper.mongo.external.bson.BsonType;
import me.lucko.helper.mongo.external.bson.BsonUndefined;
import me.lucko.helper.mongo.external.bson.BsonValue;
import me.lucko.helper.mongo.external.bson.RawBsonDocument;
import me.lucko.helper.mongo.external.bson.codecs.BsonArrayCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonBinaryCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonBooleanCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonDBPointerCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonDateTimeCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonDecimal128Codec;
import me.lucko.helper.mongo.external.bson.codecs.BsonDocumentCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonDocumentWrapperCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonDoubleCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonInt32Codec;
import me.lucko.helper.mongo.external.bson.codecs.BsonInt64Codec;
import me.lucko.helper.mongo.external.bson.codecs.BsonJavaScriptCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonJavaScriptWithScopeCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonMaxKeyCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonMinKeyCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonNullCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonObjectIdCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonRegularExpressionCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonStringCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonSymbolCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonTimestampCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonTypeClassMap;
import me.lucko.helper.mongo.external.bson.codecs.BsonUndefinedCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonValueCodec;
import me.lucko.helper.mongo.external.bson.codecs.Codec;
import me.lucko.helper.mongo.external.bson.codecs.RawBsonDocumentCodec;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecProvider;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecRegistry;

public class BsonValueCodecProvider
implements CodecProvider {
    private static final BsonTypeClassMap DEFAULT_BSON_TYPE_CLASS_MAP;
    private final Map<Class<?>, Codec<?>> codecs = new HashMap();

    public BsonValueCodecProvider() {
        this.addCodecs();
    }

    public static Class<? extends BsonValue> getClassForBsonType(BsonType bsonType) {
        return DEFAULT_BSON_TYPE_CLASS_MAP.get(bsonType);
    }

    public static BsonTypeClassMap getBsonTypeClassMap() {
        return DEFAULT_BSON_TYPE_CLASS_MAP;
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (this.codecs.containsKey(clazz)) {
            return this.codecs.get(clazz);
        }
        if (clazz == BsonArray.class) {
            return new BsonArrayCodec(registry);
        }
        if (clazz == BsonJavaScriptWithScope.class) {
            return new BsonJavaScriptWithScopeCodec(registry.get(BsonDocument.class));
        }
        if (clazz == BsonValue.class) {
            return new BsonValueCodec(registry);
        }
        if (clazz == BsonDocumentWrapper.class) {
            return new BsonDocumentWrapperCodec(registry.get(BsonDocument.class));
        }
        if (clazz == RawBsonDocument.class) {
            return new RawBsonDocumentCodec();
        }
        if (BsonDocument.class.isAssignableFrom(clazz)) {
            return new BsonDocumentCodec(registry);
        }
        return null;
    }

    private void addCodecs() {
        this.addCodec(new BsonNullCodec());
        this.addCodec(new BsonBinaryCodec());
        this.addCodec(new BsonBooleanCodec());
        this.addCodec(new BsonDateTimeCodec());
        this.addCodec(new BsonDBPointerCodec());
        this.addCodec(new BsonDoubleCodec());
        this.addCodec(new BsonInt32Codec());
        this.addCodec(new BsonInt64Codec());
        this.addCodec(new BsonDecimal128Codec());
        this.addCodec(new BsonMinKeyCodec());
        this.addCodec(new BsonMaxKeyCodec());
        this.addCodec(new BsonJavaScriptCodec());
        this.addCodec(new BsonObjectIdCodec());
        this.addCodec(new BsonRegularExpressionCodec());
        this.addCodec(new BsonStringCodec());
        this.addCodec(new BsonSymbolCodec());
        this.addCodec(new BsonTimestampCodec());
        this.addCodec(new BsonUndefinedCodec());
    }

    private <T extends BsonValue> void addCodec(Codec<T> codec) {
        this.codecs.put(codec.getEncoderClass(), codec);
    }

    static {
        HashMap map = new HashMap();
        map.put(BsonType.NULL, BsonNull.class);
        map.put(BsonType.ARRAY, BsonArray.class);
        map.put(BsonType.BINARY, BsonBinary.class);
        map.put(BsonType.BOOLEAN, BsonBoolean.class);
        map.put(BsonType.DATE_TIME, BsonDateTime.class);
        map.put(BsonType.DB_POINTER, BsonDbPointer.class);
        map.put(BsonType.DOCUMENT, BsonDocument.class);
        map.put(BsonType.DOUBLE, BsonDouble.class);
        map.put(BsonType.INT32, BsonInt32.class);
        map.put(BsonType.INT64, BsonInt64.class);
        map.put(BsonType.DECIMAL128, BsonDecimal128.class);
        map.put(BsonType.MAX_KEY, BsonMaxKey.class);
        map.put(BsonType.MIN_KEY, BsonMinKey.class);
        map.put(BsonType.JAVASCRIPT, BsonJavaScript.class);
        map.put(BsonType.JAVASCRIPT_WITH_SCOPE, BsonJavaScriptWithScope.class);
        map.put(BsonType.OBJECT_ID, BsonObjectId.class);
        map.put(BsonType.REGULAR_EXPRESSION, BsonRegularExpression.class);
        map.put(BsonType.STRING, BsonString.class);
        map.put(BsonType.SYMBOL, BsonSymbol.class);
        map.put(BsonType.TIMESTAMP, BsonTimestamp.class);
        map.put(BsonType.UNDEFINED, BsonUndefined.class);
        DEFAULT_BSON_TYPE_CLASS_MAP = new BsonTypeClassMap(map);
    }
}

