/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.bson.codecs;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.lucko.helper.mongo.external.bson.BsonDbPointer;
import me.lucko.helper.mongo.external.bson.BsonRegularExpression;
import me.lucko.helper.mongo.external.bson.BsonTimestamp;
import me.lucko.helper.mongo.external.bson.BsonType;
import me.lucko.helper.mongo.external.bson.BsonUndefined;
import me.lucko.helper.mongo.external.bson.Document;
import me.lucko.helper.mongo.external.bson.types.Binary;
import me.lucko.helper.mongo.external.bson.types.Code;
import me.lucko.helper.mongo.external.bson.types.CodeWithScope;
import me.lucko.helper.mongo.external.bson.types.Decimal128;
import me.lucko.helper.mongo.external.bson.types.MaxKey;
import me.lucko.helper.mongo.external.bson.types.MinKey;
import me.lucko.helper.mongo.external.bson.types.ObjectId;
import me.lucko.helper.mongo.external.bson.types.Symbol;

public class BsonTypeClassMap {
    private final Map<BsonType, Class<?>> map = new HashMap();

    public BsonTypeClassMap(Map<BsonType, Class<?>> replacementsForDefaults) {
        this.addDefaults();
        this.map.putAll(replacementsForDefaults);
    }

    public BsonTypeClassMap() {
        this(Collections.emptyMap());
    }

    Set<BsonType> keys() {
        return this.map.keySet();
    }

    public Class<?> get(BsonType bsonType) {
        return this.map.get((Object)bsonType);
    }

    private void addDefaults() {
        this.map.put(BsonType.ARRAY, List.class);
        this.map.put(BsonType.BINARY, Binary.class);
        this.map.put(BsonType.BOOLEAN, Boolean.class);
        this.map.put(BsonType.DATE_TIME, Date.class);
        this.map.put(BsonType.DB_POINTER, BsonDbPointer.class);
        this.map.put(BsonType.DOCUMENT, Document.class);
        this.map.put(BsonType.DOUBLE, Double.class);
        this.map.put(BsonType.INT32, Integer.class);
        this.map.put(BsonType.INT64, Long.class);
        this.map.put(BsonType.DECIMAL128, Decimal128.class);
        this.map.put(BsonType.MAX_KEY, MaxKey.class);
        this.map.put(BsonType.MIN_KEY, MinKey.class);
        this.map.put(BsonType.JAVASCRIPT, Code.class);
        this.map.put(BsonType.JAVASCRIPT_WITH_SCOPE, CodeWithScope.class);
        this.map.put(BsonType.OBJECT_ID, ObjectId.class);
        this.map.put(BsonType.REGULAR_EXPRESSION, BsonRegularExpression.class);
        this.map.put(BsonType.STRING, String.class);
        this.map.put(BsonType.SYMBOL, Symbol.class);
        this.map.put(BsonType.TIMESTAMP, BsonTimestamp.class);
        this.map.put(BsonType.UNDEFINED, BsonUndefined.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BsonTypeClassMap that = (BsonTypeClassMap)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }
}

