/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.bukkit.configuration.ConfigurationSection;

public final class MongoDatabaseCredentials {
    private final String address;
    private final int port;
    private final String database;
    private final String username;
    private final String password;

    @Nonnull
    public static MongoDatabaseCredentials of(@Nonnull String address, int port, @Nonnull String database, @Nonnull String username, @Nonnull String password) {
        return new MongoDatabaseCredentials(address, port, database, username, password);
    }

    @Nonnull
    public static MongoDatabaseCredentials fromConfig(@Nonnull ConfigurationSection config) {
        return MongoDatabaseCredentials.of(config.getString("address", "localhost"), config.getInt("port", 27017), config.getString("database", "minecraft"), config.getString("username", "root"), config.getString("password", "passw0rd"));
    }

    private MongoDatabaseCredentials(@Nonnull String address, int port, @Nonnull String database, @Nonnull String username, @Nonnull String password) {
        this.address = (String)Preconditions.checkNotNull((Object)address);
        this.port = port;
        this.database = (String)Preconditions.checkNotNull((Object)database);
        this.username = (String)Preconditions.checkNotNull((Object)username);
        this.password = (String)Preconditions.checkNotNull((Object)password);
    }

    @Nonnull
    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    @Nonnull
    public String getDatabase() {
        return this.database;
    }

    @Nonnull
    public String getUsername() {
        return this.username;
    }

    @Nonnull
    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MongoDatabaseCredentials)) {
            return false;
        }
        MongoDatabaseCredentials other = (MongoDatabaseCredentials)o;
        return this.getAddress().equals(other.getAddress()) && this.getPort() == other.getPort() && this.getDatabase().equals(other.getDatabase()) && this.getUsername().equals(other.getUsername()) && this.getPassword().equals(other.getPassword());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + this.getAddress().hashCode();
        result = result * 59 + this.getDatabase().hashCode();
        result = result * 59 + this.getUsername().hashCode();
        result = result * 59 + this.getPassword().hashCode();
        return result;
    }

    public String toString() {
        return "MongoDatabaseCredentials(address=" + this.getAddress() + ", port=" + this.getPort() + ", database=" + this.getDatabase() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }
}

