/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.configurate.toml;

import com.moandjiezana.toml.Toml;
import com.moandjiezana.toml.TomlWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import me.lucko.configurate.toml.MoreTypes;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.configurate.BasicConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.loader.AbstractConfigurationLoader;
import org.spongepowered.configurate.loader.CommentHandler;
import org.spongepowered.configurate.loader.CommentHandlers;
import org.spongepowered.configurate.loader.ParsingException;
import org.spongepowered.configurate.util.UnmodifiableCollections;

public class TOMLConfigurationLoader
extends AbstractConfigurationLoader<BasicConfigurationNode> {
    private static final Set<Class<?>> NATIVE_TYPES = UnmodifiableCollections.toSet((Object[])new Class[]{List.class, Map.class, Double.class, Instant.class, Float.class, Integer.class, Boolean.class, String.class, Long.class, Date.class});
    static final ConfigurationOptions DEFAULT_OPTIONS = ConfigurationOptions.defaults().nativeTypes(NATIVE_TYPES).serializers(MoreTypes.SERIALIZERS);
    private final int keyIndent;
    private final int tableIndent;
    private final int arrayPadding;
    private final ZoneOffset zoneOffset;
    private final boolean fractionalSeconds;

    public static @NonNull Builder builder() {
        return new Builder();
    }

    private TOMLConfigurationLoader(Builder builder) {
        super((AbstractConfigurationLoader.Builder)builder, new CommentHandler[]{CommentHandlers.HASH});
        this.keyIndent = builder.getKeyIndent();
        this.tableIndent = builder.getTableIndent();
        this.arrayPadding = builder.getArrayPadding();
        this.zoneOffset = builder.getZoneOffset();
        this.fractionalSeconds = builder.getUseFractionalSeconds();
    }

    private TomlWriter createWriter() {
        TomlWriter.Builder builder = new TomlWriter.Builder().indentTablesBy(this.tableIndent).indentValuesBy(this.keyIndent).padArrayDelimitersBy(this.arrayPadding).timeZone(TimeZone.getTimeZone(this.zoneOffset.getId()));
        if (this.fractionalSeconds) {
            builder = builder.showFractionalSeconds();
        }
        return builder.build();
    }

    protected void loadInternal(BasicConfigurationNode node, BufferedReader reader) throws ParsingException {
        Toml toml = new Toml().read((Reader)reader);
        Map map = toml.toMap();
        TOMLConfigurationLoader.readObject(map, (ConfigurationNode)node);
    }

    private static void readObject(Map<String, Object> from, ConfigurationNode to) {
        for (Map.Entry<String, Object> entry : from.entrySet()) {
            ConfigurationNode node = to.node(new Object[]{entry.getKey().replace("\"", "")});
            Object value = entry.getValue();
            if (value instanceof Map) {
                TOMLConfigurationLoader.readObject((Map)value, node);
                continue;
            }
            if (value instanceof List) {
                List list = (List)value;
                for (Object element : list) {
                    ConfigurationNode listNode = node.appendListNode();
                    if (element instanceof Map) {
                        TOMLConfigurationLoader.readObject((Map)element, listNode);
                        continue;
                    }
                    listNode.raw(element);
                }
                continue;
            }
            node.raw(value);
        }
    }

    protected void saveInternal(ConfigurationNode node, Writer writer) throws ConfigurateException {
        try {
            Map<String, Object> map = TOMLConfigurationLoader.writeNode(node);
            this.createWriter().write(map, writer);
        }
        catch (IOException e) {
            throw ConfigurateException.wrap((ConfigurationNode)node, (IOException)e);
        }
    }

    private static Map<String, Object> writeNode(ConfigurationNode from) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : from.childrenMap().entrySet()) {
            ConfigurationNode node = (ConfigurationNode)entry.getValue();
            if (node.isList()) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (ConfigurationNode listNode : node.childrenList()) {
                    if (listNode.isMap()) {
                        list.add(TOMLConfigurationLoader.writeNode(listNode));
                        continue;
                    }
                    list.add(listNode.raw());
                }
                map.put(entry.getKey().toString(), list);
                continue;
            }
            if (node.isMap()) {
                map.put(entry.getKey().toString(), TOMLConfigurationLoader.writeNode(node));
                continue;
            }
            if (node.raw() instanceof Instant) {
                map.put(entry.getKey().toString(), MoreTypes.asDate(node.raw()));
                continue;
            }
            map.put(entry.getKey().toString(), node.raw());
        }
        return map;
    }

    public BasicConfigurationNode createNode(ConfigurationOptions options) {
        return BasicConfigurationNode.root((ConfigurationOptions)options.nativeTypes(NATIVE_TYPES));
    }

    public static class Builder
    extends AbstractConfigurationLoader.Builder<Builder, TOMLConfigurationLoader> {
        private int keyIndent = 0;
        private int tableIndent = 0;
        private int arrayPadding = 0;
        private ZoneOffset zoneOffset = ZoneOffset.UTC;
        private boolean fractionalSeconds = false;

        Builder() {
            this.defaultOptions(DEFAULT_OPTIONS);
        }

        public @NonNull Builder setKeyIndent(int indent) {
            this.keyIndent = indent;
            return this;
        }

        public int getKeyIndent() {
            return this.keyIndent;
        }

        public @NonNull Builder setTableIndent(int indent) {
            this.tableIndent = indent;
            return this;
        }

        public int getTableIndent() {
            return this.tableIndent;
        }

        public @NonNull Builder setZoneOffset(@NonNull ZoneOffset offset) {
            this.zoneOffset = offset;
            return this;
        }

        public @NonNull ZoneOffset getZoneOffset() {
            return this.zoneOffset;
        }

        public @NonNull Builder setArrayPadding(int padding) {
            this.arrayPadding = padding;
            return this;
        }

        public int getArrayPadding() {
            return this.arrayPadding;
        }

        public @NonNull Builder setUseFractionalSeconds(boolean fractionalSeconds) {
            this.fractionalSeconds = fractionalSeconds;
            return this;
        }

        public boolean getUseFractionalSeconds() {
            return this.fractionalSeconds;
        }

        public @NonNull TOMLConfigurationLoader build() {
            this.defaultOptions(o -> o.nativeTypes(NATIVE_TYPES));
            return new TOMLConfigurationLoader(this);
        }
    }
}

