/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.configurate.toml;

import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;

class MoreTypes {
    static final TypeSerializerCollection SERIALIZERS = TypeSerializerCollection.defaults().childBuilder().register((ScalarSerializer)new InstantSerializer()).register((ScalarSerializer)new DateSerializer()).build();

    MoreTypes() {
    }

    public static @Nullable Date asDate(Object value) {
        TemporalAccessor temp;
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof TemporalAccessor && (temp = (TemporalAccessor)value).isSupported(ChronoField.INSTANT_SECONDS)) {
            long millis = temp.get(ChronoField.INSTANT_SECONDS) * 1000;
            if (temp.isSupported(ChronoField.MILLI_OF_SECOND)) {
                millis += (long)temp.get(ChronoField.MILLI_OF_SECOND);
            }
            return new Date(millis);
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        String dateString = value.toString();
        try {
            return DateFormat.getInstance().parse(dateString);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public static @Nullable Date strictAsDate(Object value) {
        if (value == null) {
            return null;
        }
        return value instanceof Date ? (Date)value : null;
    }

    public static @Nullable Instant asInstant(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Instant) {
            return (Instant)value;
        }
        if (value instanceof Date) {
            return Instant.ofEpochMilli(((Date)value).getTime());
        }
        if (value instanceof TemporalAccessor) {
            try {
                return Instant.from((TemporalAccessor)value);
            }
            catch (DateTimeException ex) {
                return null;
            }
        }
        String dateString = value.toString();
        try {
            return Instant.parse(dateString);
        }
        catch (DateTimeParseException ex) {
            return null;
        }
    }

    public static @Nullable Instant strictAsInstant(Object value) {
        if (value == null) {
            return null;
        }
        return value instanceof Instant ? (Instant)value : null;
    }

    private static class InstantSerializer
    extends ScalarSerializer<Instant> {
        InstantSerializer() {
            super(Instant.class);
        }

        public Instant deserialize(Type type, Object obj) {
            return MoreTypes.asInstant(obj);
        }

        protected Object serialize(Instant item, Predicate<Class<?>> typeSupported) {
            return DateTimeFormatter.ISO_INSTANT.format(item);
        }
    }

    private static class DateSerializer
    extends ScalarSerializer<Date> {
        DateSerializer() {
            super(Date.class);
        }

        public Date deserialize(Type type, Object obj) {
            return MoreTypes.asDate(obj);
        }

        protected Object serialize(Date item, Predicate<Class<?>> typeSupported) {
            return DateFormat.getInstance().format(item);
        }
    }
}

