/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.toml;

import com.google.common.reflect.TypeToken;
import java.text.DateFormat;
import java.text.ParseException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializers;
import org.checkerframework.checker.nullness.qual.Nullable;

class MoreTypes {
    MoreTypes() {
    }

    static void registerSerializers() {
    }

    public static @Nullable Date asDate(Object value) {
        TemporalAccessor temp;
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof TemporalAccessor && (temp = (TemporalAccessor)value).isSupported(ChronoField.INSTANT_SECONDS)) {
            long millis = temp.get(ChronoField.INSTANT_SECONDS) * 1000;
            if (temp.isSupported(ChronoField.MILLI_OF_SECOND)) {
                millis += (long)temp.get(ChronoField.MILLI_OF_SECOND);
            }
            return new Date(millis);
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        String dateString = value.toString();
        try {
            return DateFormat.getInstance().parse(dateString);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public static @Nullable Date strictAsDate(Object value) {
        if (value == null) {
            return null;
        }
        return value instanceof Date ? (Date)value : null;
    }

    public static @Nullable Instant asInstant(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Instant) {
            return (Instant)value;
        }
        if (value instanceof Date) {
            return Instant.ofEpochMilli(((Date)value).getTime());
        }
        if (value instanceof TemporalAccessor) {
            try {
                return Instant.from((TemporalAccessor)value);
            }
            catch (DateTimeException ex) {
                return null;
            }
        }
        String dateString = value.toString();
        try {
            return Instant.parse(dateString);
        }
        catch (DateTimeParseException ex) {
            return null;
        }
    }

    public static @Nullable Instant strictAsInstant(Object value) {
        if (value == null) {
            return null;
        }
        return value instanceof Instant ? (Instant)value : null;
    }

    static {
        TypeSerializers.getDefaultSerializers().registerType(TypeToken.of(Instant.class), (TypeSerializer)new InstantSerializer());
        TypeSerializers.getDefaultSerializers().registerType(TypeToken.of(Date.class), (TypeSerializer)new DateSerializer());
    }

    private static class DateSerializer
    implements TypeSerializer<Date> {
        private DateSerializer() {
        }

        public Date deserialize(TypeToken<?> type, ConfigurationNode value) throws ObjectMappingException {
            return MoreTypes.asDate(value.getValue());
        }

        public void serialize(TypeToken<?> type, Date obj, ConfigurationNode value) throws ObjectMappingException {
            value.setValue((Object)obj);
        }
    }

    private static class InstantSerializer
    implements TypeSerializer<Instant> {
        private InstantSerializer() {
        }

        public Instant deserialize(TypeToken<?> type, ConfigurationNode value) throws ObjectMappingException {
            return MoreTypes.asInstant(value.getValue());
        }

        public void serialize(TypeToken<?> type, Instant obj, ConfigurationNode value) throws ObjectMappingException {
            value.setValue((Object)obj);
        }
    }
}

