/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.toml;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.moandjiezana.toml.Toml;
import com.moandjiezana.toml.TomlWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.SimpleConfigurationNode;
import ninja.leaping.configurate.Types;
import ninja.leaping.configurate.loader.AbstractConfigurationLoader;
import ninja.leaping.configurate.loader.CommentHandler;
import ninja.leaping.configurate.loader.CommentHandlers;
import org.checkerframework.checker.nullness.qual.NonNull;

public class TOMLConfigurationLoader
extends AbstractConfigurationLoader<ConfigurationNode> {
    private final int keyIndent;
    private final int tableIndent;
    private final int arrayPadding;
    private final ZoneOffset zoneOffset;
    private final boolean fractionalSeconds;

    public static @NonNull Builder builder() {
        return new Builder();
    }

    private TOMLConfigurationLoader(Builder builder) {
        super((AbstractConfigurationLoader.Builder)builder, new CommentHandler[]{CommentHandlers.HASH});
        this.keyIndent = builder.getKeyIndent();
        this.tableIndent = builder.getTableIndent();
        this.arrayPadding = builder.getArrayPadding();
        this.zoneOffset = builder.getZoneOffset();
        this.fractionalSeconds = builder.getUseFractionalSeconds();
    }

    private TomlWriter createWriter() {
        TomlWriter.Builder builder = new TomlWriter.Builder().indentTablesBy(this.tableIndent).indentValuesBy(this.keyIndent).padArrayDelimitersBy(this.arrayPadding).timeZone(TimeZone.getTimeZone(this.zoneOffset.getId()));
        if (this.fractionalSeconds) {
            builder = builder.showFractionalSeconds();
        }
        return builder.build();
    }

    protected void loadInternal(ConfigurationNode node, BufferedReader reader) throws IOException {
        Toml toml = new Toml().read((Reader)reader);
        Map map = toml.toMap();
        TOMLConfigurationLoader.readObject(map, node);
    }

    private static void readObject(Map<String, Object> from, ConfigurationNode to) {
        for (Map.Entry<String, Object> entry : from.entrySet()) {
            ConfigurationNode node = to.getNode(new Object[]{entry.getKey().replace("\"", "")});
            Object value = entry.getValue();
            if (value instanceof Map) {
                TOMLConfigurationLoader.readObject((Map)value, node);
                continue;
            }
            if (value instanceof List) {
                List list = (List)value;
                for (Object element : list) {
                    ConfigurationNode listNode = node.getAppendedNode();
                    if (element instanceof Map) {
                        TOMLConfigurationLoader.readObject((Map)element, listNode);
                        continue;
                    }
                    listNode.setValue(element);
                }
                continue;
            }
            node.setValue(value);
        }
    }

    protected void saveInternal(ConfigurationNode node, Writer writer) throws IOException {
        Map<String, Object> map = TOMLConfigurationLoader.writeNode(node);
        this.createWriter().write(map, writer);
    }

    private static Map<String, Object> writeNode(ConfigurationNode from) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : from.getChildrenMap().entrySet()) {
            ConfigurationNode node = (ConfigurationNode)entry.getValue();
            if (node.hasListChildren()) {
                ArrayList list = Lists.newArrayList();
                for (ConfigurationNode listNode : node.getChildrenList()) {
                    if (listNode.hasMapChildren()) {
                        list.add(TOMLConfigurationLoader.writeNode(listNode));
                        continue;
                    }
                    list.add(listNode.getValue());
                }
                map.put(entry.getKey().toString(), list);
                continue;
            }
            if (node.hasMapChildren()) {
                map.put(entry.getKey().toString(), TOMLConfigurationLoader.writeNode(node));
                continue;
            }
            if (node.getValue() instanceof Instant) {
                map.put(entry.getKey().toString(), Types.asDate((Object)node.getValue()));
                continue;
            }
            map.put(entry.getKey().toString(), node.getValue());
        }
        return map;
    }

    public @NonNull ConfigurationNode createEmptyNode(@NonNull ConfigurationOptions options) {
        options = options.setAcceptedTypes((Set)ImmutableSet.of(List.class, Map.class, Double.class, Instant.class, Float.class, Integer.class, (Object[])new Class[]{Boolean.class, String.class, Long.class, Date.class}));
        return SimpleConfigurationNode.root((ConfigurationOptions)options);
    }

    public static class Builder
    extends AbstractConfigurationLoader.Builder<Builder> {
        private int keyIndent = 0;
        private int tableIndent = 0;
        private int arrayPadding = 0;
        private ZoneOffset zoneOffset = ZoneOffset.UTC;
        private boolean fractionalSeconds = false;

        public @NonNull Builder setKeyIndent(int indent) {
            this.keyIndent = indent;
            return this;
        }

        public int getKeyIndent() {
            return this.keyIndent;
        }

        public @NonNull Builder setTableIndent(int indent) {
            this.tableIndent = indent;
            return this;
        }

        public int getTableIndent() {
            return this.tableIndent;
        }

        public @NonNull Builder setZoneOffset(@NonNull ZoneOffset offset) {
            this.zoneOffset = offset;
            return this;
        }

        public @NonNull ZoneOffset getZoneOffset() {
            return this.zoneOffset;
        }

        public @NonNull Builder setArrayPadding(int padding) {
            this.arrayPadding = padding;
            return this;
        }

        public int getArrayPadding() {
            return this.arrayPadding;
        }

        public @NonNull Builder setUseFractionalSeconds(boolean fractionalSeconds) {
            this.fractionalSeconds = fractionalSeconds;
            return this;
        }

        public boolean getUseFractionalSeconds() {
            return this.fractionalSeconds;
        }

        public @NonNull TOMLConfigurationLoader build() {
            return new TOMLConfigurationLoader(this);
        }
    }
}

