/*
 * Configurate
 * Copyright (C) zml and Configurate contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ninja.leaping.configurate.objectmapping;

import com.google.common.reflect.TypeToken;

/**
 * Extension of {@link ObjectMappingException} for instances where the present {@link TypeToken type}
 * is invalid.
 */
public class InvalidTypeException extends ObjectMappingException {

    public InvalidTypeException(TypeToken<?> received) {
        super("Invalid type presented to serializer: " + received);
    }

}
