/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.commodore.file;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import me.lucko.commodore.file.Lexer;

class Parser<S> {
    private final Lexer lexer;

    Parser(Lexer lexer) {
        this.lexer = lexer;
    }

    LiteralCommandNode<S> parse() {
        CommandNode<S> node = this.parseNode();
        if (!(node instanceof LiteralCommandNode)) {
            throw new ParserException(this, "Root command node is not a literal command node");
        }
        if (this.lexer.peek() != Lexer.ConstantToken.EOF) {
            throw new ParserException(this, "Expected end of file but got " + this.lexer.peek());
        }
        return (LiteralCommandNode)node;
    }

    private CommandNode<S> parseNode() {
        Lexer.Token token = (Lexer.Token)this.lexer.next();
        if (!(token instanceof Lexer.StringToken)) {
            throw new ParserException(this, "Expected string token for node name but got " + token);
        }
        String name = ((Lexer.StringToken)token).string;
        Object node = this.lexer.peek() instanceof Lexer.StringToken ? RequiredArgumentBuilder.argument((String)name, this.parseArgumentType()) : LiteralArgumentBuilder.literal((String)name);
        if (this.lexer.peek() == Lexer.ConstantToken.OPEN_BRACKET) {
            this.lexer.next();
            while (this.lexer.peek() != Lexer.ConstantToken.CLOSE_BRACKET) {
                CommandNode<S> child = this.parseNode();
                node.then(child);
            }
            this.lexer.next();
        } else {
            if (this.lexer.peek() != Lexer.ConstantToken.SEMICOLON) {
                throw new ParserException(this, "Node definition not ended with semicolon, got " + this.lexer.peek());
            }
            this.lexer.next();
        }
        return node.build();
    }

    private ArgumentType<?> parseArgumentType() {
        String argumentType;
        Lexer.Token token = (Lexer.Token)this.lexer.next();
        if (!(token instanceof Lexer.StringToken)) {
            throw new ParserException(this, "Expected string token for argument type but got " + token);
        }
        switch (argumentType = ((Lexer.StringToken)token).string) {
            case "brigadier:bool": {
                return BoolArgumentType.bool();
            }
            case "brigadier:string": {
                return this.parseStringArgumentType();
            }
            case "brigadier:integer": {
                return IntegerArgumentType.integer();
            }
            case "brigadier:long": {
                return LongArgumentType.longArg();
            }
            case "brigadier:float": {
                return FloatArgumentType.floatArg();
            }
            case "brigadier:double": {
                return DoubleArgumentType.doubleArg();
            }
        }
        throw new ParserException(this, "Unknown argument type: " + argumentType);
    }

    private StringArgumentType parseStringArgumentType() {
        String stringType;
        Lexer.Token token = (Lexer.Token)this.lexer.next();
        if (!(token instanceof Lexer.StringToken)) {
            throw new ParserException(this, "Expected string token for string type but got " + token);
        }
        switch (stringType = ((Lexer.StringToken)token).string) {
            case "single_word": {
                return StringArgumentType.word();
            }
            case "quotable_phrase": {
                return StringArgumentType.string();
            }
            case "greedy_phrase": {
                return StringArgumentType.greedyString();
            }
        }
        throw new ParserException(this, "Unknown string type: " + stringType);
    }

    static final class ParserException
    extends RuntimeException {
        private ParserException(Parser<?> parser, String message) {
            super(message + " (at line " + ((Parser)parser).lexer.currentLine() + ")");
        }
    }
}

