/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.commodore.file;

import com.mojang.brigadier.tree.LiteralCommandNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import me.lucko.commodore.file.Lexer;
import me.lucko.commodore.file.Parser;

public final class CommodoreFileFormat {
    private CommodoreFileFormat() {
    }

    public static <S> LiteralCommandNode<S> parse(Reader reader) throws IOException {
        try {
            return new Parser(new Lexer(reader)).parse();
        }
        catch (Lexer.LexerException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public static <S> LiteralCommandNode<S> parse(InputStream inputStream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream);){
            LiteralCommandNode<S> literalCommandNode = CommodoreFileFormat.parse(reader);
            return literalCommandNode;
        }
    }

    public static <S> LiteralCommandNode<S> parse(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            LiteralCommandNode<S> literalCommandNode = CommodoreFileFormat.parse(reader);
            return literalCommandNode;
        }
    }

    public static <S> LiteralCommandNode<S> parse(File file) throws IOException {
        return CommodoreFileFormat.parse(file.toPath());
    }
}

