/*
 * Decompiled with CFR 0.152.
 */
package me.devnatan.inventoryframework.context;

import java.util.Objects;
import me.devnatan.inventoryframework.RootView;

public final class EndlessContextInfo {
    private final String contextId;
    private final RootView view;
    private boolean invalidated;

    public EndlessContextInfo(String contextId, RootView view) {
        this.contextId = contextId;
        this.view = view;
    }

    public String getContextId() {
        return this.contextId;
    }

    public RootView getView() {
        return this.view;
    }

    public void invalidate() {
        this.getView().invalidateEndlessContext(this.contextId);
        this.invalidated = true;
    }

    public boolean wasInvalidated() {
        return this.invalidated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndlessContextInfo that = (EndlessContextInfo)o;
        return Objects.equals(this.contextId, that.contextId) && Objects.equals(this.view, that.view);
    }

    public int hashCode() {
        return Objects.hash(this.contextId, this.view);
    }

    public String toString() {
        return "EndlessContextData{contextId='" + this.contextId + '\'' + ", view=" + this.view + '}';
    }
}

