/*
 * Decompiled with CFR 0.152.
 */
package me.devnatan.inventoryframework.component;

import java.util.function.BiConsumer;
import java.util.function.Function;
import me.devnatan.inventoryframework.component.ComponentFactory;
import me.devnatan.inventoryframework.component.ItemComponentBuilder;
import me.devnatan.inventoryframework.component.Pagination;
import me.devnatan.inventoryframework.component.PaginationElementFactory;
import me.devnatan.inventoryframework.component.PaginationValueConsumer;
import me.devnatan.inventoryframework.context.IFContext;
import me.devnatan.inventoryframework.internal.ElementFactory;
import me.devnatan.inventoryframework.state.State;
import org.jetbrains.annotations.NotNull;

public final class PaginationStateBuilder<Context extends IFContext, Builder extends ItemComponentBuilder<Builder, Context> & ComponentFactory, V> {
    private final ElementFactory internalElementFactory;
    private final Object sourceProvider;
    private final Function<PaginationStateBuilder<Context, Builder, V>, State<Pagination>> internalStateFactory;
    private char layoutTarget = (char)79;
    private PaginationElementFactory<V> paginationElementFactory;
    private BiConsumer<Context, Pagination> pageSwitchHandler;
    private final boolean async;
    private final boolean computed;

    public PaginationStateBuilder(ElementFactory internalElementFactory, Object sourceProvider, Function<PaginationStateBuilder<Context, Builder, V>, State<Pagination>> internalStateFactory, boolean async, boolean computed) {
        this.internalElementFactory = internalElementFactory;
        this.internalStateFactory = internalStateFactory;
        this.sourceProvider = sourceProvider;
        this.async = async;
        this.computed = computed;
    }

    public PaginationStateBuilder<Context, Builder, V> itemFactory(@NotNull BiConsumer<Builder, V> itemFactory) {
        return this.elementFactory((context, builder, index, value) -> itemFactory.accept(builder, value));
    }

    public PaginationStateBuilder<Context, Builder, V> elementFactory(@NotNull PaginationValueConsumer<Context, Builder, V> elementConsumer) {
        this.paginationElementFactory = (pagination, index, slot, value) -> {
            IFContext context = (IFContext)pagination.getRoot();
            ItemComponentBuilder builder = (ItemComponentBuilder)this.internalElementFactory.createComponentBuilder(pagination);
            builder.withSlot(slot).withExternallyManaged(true);
            elementConsumer.accept(context, builder, index, value);
            return (ComponentFactory)((Object)builder);
        };
        return this;
    }

    public PaginationStateBuilder<Context, Builder, V> layoutTarget(char layoutTarget) {
        this.layoutTarget = layoutTarget;
        return this;
    }

    public PaginationStateBuilder<Context, Builder, V> onPageSwitch(@NotNull BiConsumer<Context, Pagination> pageSwitchHandler) {
        this.pageSwitchHandler = pageSwitchHandler;
        return this;
    }

    public State<Pagination> build() {
        if (this.paginationElementFactory == null) {
            throw new IllegalStateException(String.format("Element factory from #buildPaginationState(...) cannot be null. Set it using %s or %s.", "#elementFactory(PaginationElementFactory)", "#itemFactory(BiConsumer)"));
        }
        return this.internalStateFactory.apply(this);
    }

    public char getLayoutTarget() {
        return this.layoutTarget;
    }

    public Object getSourceProvider() {
        return this.sourceProvider;
    }

    public boolean isAsync() {
        return this.async;
    }

    public boolean isComputed() {
        return this.computed;
    }

    public BiConsumer<Context, Pagination> getPageSwitchHandler() {
        return this.pageSwitchHandler;
    }

    public PaginationElementFactory<V> getPaginationElementFactory() {
        return this.paginationElementFactory;
    }
}

