/*
 * Decompiled with CFR 0.152.
 */
package me.devnatan.inventoryframework.state;

import java.util.Objects;
import me.devnatan.inventoryframework.state.StateValue;
import me.devnatan.inventoryframework.state.StateValueHost;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class StateValueDiff {
    private final transient StateValueHost host;
    private final transient StateValue holderValue;
    private final Object oldValue;
    private final Object newValue;

    public StateValueDiff(StateValueHost host, StateValue holderValue, Object oldValue, Object newValue) {
        this.host = host;
        this.holderValue = holderValue;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public StateValueHost getHost() {
        return this.host;
    }

    public StateValue getValue() {
        return this.holderValue;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateValueDiff that = (StateValueDiff)o;
        return Objects.equals(this.oldValue, that.oldValue) && Objects.equals(this.newValue, that.newValue);
    }

    public int hashCode() {
        return Objects.hash(this.oldValue, this.newValue);
    }

    public String toString() {
        return "StateValueDiff{holderValue=" + this.holderValue + ", oldValue=" + this.oldValue + ", newValue=" + this.newValue + '}';
    }
}

