/*
 * Decompiled with CFR 0.152.
 */
package me.devnatan.inventoryframework.pipeline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.devnatan.inventoryframework.pipeline.PipelineContext;
import me.devnatan.inventoryframework.pipeline.PipelineInterceptor;
import me.devnatan.inventoryframework.pipeline.PipelinePhase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class Pipeline<S> {
    private final List<PipelinePhase> _phases;
    private final Map<PipelinePhase, List<PipelineInterceptor<S>>> interceptors = new HashMap<PipelinePhase, List<PipelineInterceptor<S>>>();

    public Pipeline(PipelinePhase ... phases) {
        this._phases = new LinkedList<PipelinePhase>(Arrays.asList(phases));
    }

    private PipelinePhase findPhase(@NotNull PipelinePhase phase) {
        List<PipelinePhase> phasesList = this._phases;
        for (int i = 0; i < phasesList.size(); ++i) {
            PipelinePhase curr = phasesList.get(i);
            if (!curr.equals(phase)) continue;
            phasesList.set(i, phase);
            return curr;
        }
        return null;
    }

    private int findIndexOrThrow(@NotNull PipelinePhase phase) {
        ArrayList<PipelinePhase> phasesList = new ArrayList<PipelinePhase>(this._phases);
        for (int i = 0; i < phasesList.size(); ++i) {
            PipelinePhase curr = (PipelinePhase)phasesList.get(i);
            if (!curr.equals(phase)) continue;
            return i;
        }
        throw new IllegalArgumentException(String.format("Phase %s was not registered for this pipeline", phase));
    }

    public boolean hasPhase(@NotNull PipelinePhase phase) {
        ArrayList<PipelinePhase> phasesList = new ArrayList<PipelinePhase>(this._phases);
        for (PipelinePhase curr : phasesList) {
            if (!curr.equals(phase)) continue;
            return true;
        }
        return false;
    }

    public void addPhase(@NotNull PipelinePhase phase) {
        if (this.hasPhase(phase)) {
            return;
        }
        this._phases.add(phase);
    }

    public void insertPhaseBefore(@NotNull PipelinePhase reference, @NotNull PipelinePhase phase) {
        if (this.hasPhase(phase)) {
            return;
        }
        int refIdx = this.findIndexOrThrow(reference);
        this._phases.add(refIdx, phase);
    }

    public void insertPhaseAfter(@NotNull PipelinePhase reference, @NotNull PipelinePhase phase) {
        if (this.hasPhase(phase)) {
            return;
        }
        int refIdx = this.findIndexOrThrow(reference);
        this._phases.add(refIdx + 1, phase);
    }

    public void intercept(@NotNull PipelinePhase phase, @NotNull PipelineInterceptor<? extends S> interceptor) {
        PipelinePhase pipelinePhase = this.findPhase(phase);
        if (pipelinePhase == null) {
            throw new IllegalArgumentException(String.format("Phase %s was not registered for this pipeline", phase));
        }
        this.interceptors.computeIfAbsent(phase, $ -> new ArrayList()).add(interceptor);
    }

    public void addInterceptor(PipelineInterceptor<? extends S> interceptor) {
        for (PipelinePhase phase : this._phases) {
            this.intercept(phase, interceptor);
        }
    }

    public void removeInterceptor(@NotNull PipelineInterceptor<? extends S> interceptor) {
        for (Map.Entry<PipelinePhase, List<PipelineInterceptor<S>>> registeredInterceptor : this.interceptors.entrySet()) {
            registeredInterceptor.getValue().remove(interceptor);
        }
    }

    public void removeInterceptor(@NotNull PipelinePhase phase, @NotNull PipelineInterceptor<? extends S> interceptor) {
        this.interceptors.computeIfAbsent(phase, $ -> new ArrayList()).remove(interceptor);
    }

    public void execute(@Nullable S subject) {
        LinkedList pipelineInterceptors = new LinkedList();
        for (PipelinePhase phase : this._phases) {
            List<PipelineInterceptor<S>> interceptors = this.interceptors.get(phase);
            if (interceptors == null) continue;
            pipelineInterceptors.addAll(interceptors);
        }
        PipelineContext<S> context = new PipelineContext<S>(null, pipelineInterceptors);
        context.execute(subject);
    }

    @TestOnly
    public void execute(@NotNull PipelinePhase phase, @Nullable S subject) {
        PipelineContext<S> context = new PipelineContext<S>(phase, this.interceptors.getOrDefault(phase, Collections.emptyList()));
        context.execute(subject);
    }
}

