/*
 * Decompiled with CFR 0.152.
 */
package me.devnatan.inventoryframework.internal;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntFunction;
import me.devnatan.inventoryframework.component.Component;
import me.devnatan.inventoryframework.component.ComponentBuilder;
import org.jetbrains.annotations.Nullable;

public final class LayoutSlot {
    public static final char DEFAULT_SLOT_FILL_CHAR = 'O';
    private final char character;
    private final IntFunction<ComponentBuilder> builderFactory;
    private final IntFunction<Component> componentFactory;
    private final int[] positions;

    public LayoutSlot(char character, IntFunction<ComponentBuilder> builderFactory, IntFunction<Component> componentFactory, int[] positions) {
        this.character = character;
        this.builderFactory = builderFactory;
        this.componentFactory = componentFactory;
        this.positions = positions;
    }

    public char getCharacter() {
        return this.character;
    }

    public IntFunction<ComponentBuilder> getBuilderFactory() {
        return this.builderFactory;
    }

    public IntFunction<Component> getComponentFactory() {
        return this.componentFactory;
    }

    public LayoutSlot withBuilderFactory(@Nullable IntFunction<ComponentBuilder> factory) {
        return new LayoutSlot(this.character, factory, this.componentFactory, this.positions);
    }

    public LayoutSlot withComponentFactory(@Nullable IntFunction<Component> factory) {
        return new LayoutSlot(this.character, this.builderFactory, factory, this.positions);
    }

    public int[] getPositions() {
        return this.positions;
    }

    public boolean isInPosition(int position) {
        for (int layoutPosition : this.getPositions()) {
            if (layoutPosition != position) continue;
            return true;
        }
        return false;
    }

    public boolean isDefinedByTheUser() {
        return this.builderFactory != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LayoutSlot that = (LayoutSlot)o;
        return this.getCharacter() == that.getCharacter();
    }

    public int hashCode() {
        return Objects.hash(Character.valueOf(this.getCharacter()));
    }

    public String toString() {
        return "LayoutSlot{character=" + this.character + ", builderFactory=" + this.builderFactory + ", componentFactory=" + this.componentFactory + ", positions=" + Arrays.toString(this.positions) + '}';
    }
}

