/*
 * Decompiled with CFR 0.152.
 */
package me.devnatan.inventoryframework;

import java.util.Objects;

public final class ViewType {
    public static final ViewType CHEST = new ViewType("chest", 54, 6, 9, true);
    public static final ViewType HOPPER = new ViewType("hopper", 5, 1, 5);
    public static final ViewType DROPPER = new ViewType("dropper", 9, 3, 3);
    public static final ViewType DISPENSER = new ViewType("dispenser", 9, 3, 3);
    public static final ViewType FURNACE = new ViewType("furnace", 3, 2, 2, false, new int[]{2});
    public static final ViewType BLAST_FURNACE = new ViewType("blast-furnace", 3, 2, 2, false, new int[]{2});
    public static final ViewType CRAFTING_TABLE = new ViewType("crafting-table", 9, 3, 3, false, new int[]{3});
    public static final ViewType BREWING_STAND = new ViewType("brewing-stand", 4, 1, 1, false, new int[]{0, 1, 2}, false);
    public static final ViewType BEACON = new ViewType("beacon", 1, 1, 1);
    public static final ViewType ANVIL = new ViewType("anvil", 3, 1, 3, false, new int[]{2});
    public static final ViewType SHULKER_BOX = new ViewType("shulker-box", 27, 3, 9);
    public static final ViewType SMOKER = new ViewType("smoker", 3, 2, 2, false, new int[]{2});
    public static final ViewType VILLAGER_TRADING = new ViewType("villager-trading", 3, 1, 3, false, new int[]{2});
    public static final ViewType PLAYER = new ViewType("player", 36, 3, 9, false);
    private static final int[] EMPTY_RESULT_SLOTS = new int[0];
    private final String identifier;
    private final int maxSize;
    private final int rows;
    private final int columns;
    private final boolean extendable;
    private final int[] resultSlots;
    private final boolean aligned;

    ViewType(String identifier, int maxSize, int rows, int columns) {
        this(identifier, maxSize, rows, columns, false);
    }

    ViewType(String identifier, int maxSize, int rows, int columns, boolean extendable) {
        this(identifier, maxSize, rows, columns, extendable, EMPTY_RESULT_SLOTS);
    }

    ViewType(String identifier, int maxSize, int rows, int columns, boolean extendable, int[] resultSlots) {
        this(identifier, maxSize, rows, columns, extendable, resultSlots, true);
    }

    ViewType(String identifier, int maxSize, int rows, int columns, boolean extendable, int[] resultSlots, boolean aligned) {
        this.identifier = identifier;
        this.maxSize = maxSize;
        this.rows = rows;
        this.columns = columns;
        this.extendable = extendable;
        this.resultSlots = resultSlots;
        this.aligned = aligned;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public boolean isExtendable() {
        return this.extendable;
    }

    public int[] getResultSlots() {
        return this.resultSlots;
    }

    public boolean isResultSlot(int slot) {
        if (this.resultSlots == null) {
            return false;
        }
        for (int resultSlot : this.resultSlots) {
            if (resultSlot != slot) continue;
            return true;
        }
        return false;
    }

    public boolean isAligned() {
        return this.aligned;
    }

    public boolean canPlayerInteractOn(int slot) {
        if (this.getResultSlots() != null) {
            for (int resultSlot : this.getResultSlots()) {
                if (resultSlot != slot) continue;
                return false;
            }
        }
        return true;
    }

    public int normalize(int size) {
        int fullSize;
        if (size == 0) {
            return size;
        }
        if (size <= this.getRows()) {
            fullSize = size * this.getColumns();
        } else if (size == Integer.MAX_VALUE) {
            fullSize = this.getMaxSize();
        } else {
            if (size % this.getColumns() != 0) {
                throw new IllegalArgumentException(String.format("Container size must be a multiple of %d (given: %d)", this.getColumns(), size));
            }
            fullSize = size;
        }
        if (fullSize > this.getMaxSize()) {
            throw new IllegalArgumentException(String.format("Size cannot exceed container max size of %d (given: %d (%s rows))", this.getMaxSize(), fullSize, size));
        }
        return fullSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewType viewType = (ViewType)o;
        return Objects.equals(this.getIdentifier(), viewType.getIdentifier());
    }

    public int hashCode() {
        return Objects.hash(this.getIdentifier());
    }

    public String toString() {
        return "ViewType{identifier='" + this.identifier + '\'' + ", maxSize=" + this.maxSize + ", rows=" + this.rows + ", columns=" + this.columns + ", extendable=" + this.extendable + '}';
    }
}

