/*
 * Decompiled with CFR 0.152.
 */
package me.devnatan.inventoryframework;

import me.devnatan.inventoryframework.ViewType;
import me.devnatan.inventoryframework.Viewer;
import me.devnatan.inventoryframework.VirtualView;
import me.devnatan.inventoryframework.component.Component;
import me.devnatan.inventoryframework.context.IFComponentContext;
import me.devnatan.inventoryframework.context.IFRenderContext;
import me.devnatan.inventoryframework.context.IFSlotContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ViewContainer {
    @NotNull
    public ViewType getType();

    public int getFirstSlot();

    public int getLastSlot();

    public boolean hasItem(int var1);

    public void removeItem(int var1);

    public void renderItem(int var1, Object var2);

    public int getSize();

    public int getSlotsCount();

    public int getRowsCount();

    public int getColumnsCount();

    public void open(@NotNull Viewer var1);

    public void close();

    public void close(@NotNull Viewer var1);

    public void changeTitle(@Nullable String var1, @NotNull Viewer var2);

    public boolean isEntityContainer();

    public boolean isProxied();

    public boolean isExternal();

    public ViewContainer at(int var1);

    public static ViewContainer from(VirtualView view) {
        if (view instanceof IFRenderContext) {
            return ((IFRenderContext)view).getContainer();
        }
        if (view instanceof IFSlotContext) {
            return ((IFSlotContext)view).getContainer();
        }
        if (view instanceof IFComponentContext) {
            return ((IFComponentContext)view).getComponent().getContainer();
        }
        if (view instanceof Component) {
            return ((Component)view).getContainer();
        }
        throw new IllegalArgumentException("Unable to get ViewContainer from root: " + view.getClass().getName());
    }
}

