/*
 * Decompiled with CFR 0.152.
 */
package me.devnatan.inventoryframework;

import java.time.Duration;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.devnatan.inventoryframework.ViewConfig;
import me.devnatan.inventoryframework.ViewType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class ViewConfigBuilder {
    private static boolean titleAsComponentSupported;
    private Object title;
    private int size = 0;
    private ViewType type;
    private final Set<ViewConfig.Option<?>> options = new HashSet();
    private String[] layout = null;
    private final Set<ViewConfig.Modifier> modifiers = new HashSet<ViewConfig.Modifier>();
    private long updateIntervalInTicks;
    private long interactionDelayInMillis;
    private boolean transitiveInitialData;

    public ViewConfigBuilder inheritFrom(@NotNull ViewConfigBuilder other) {
        throw new UnsupportedOperationException("Inheritance is not yet supported");
    }

    public ViewConfigBuilder type(ViewType type) {
        this.type = type;
        return this;
    }

    public ViewConfigBuilder title(Object title) {
        this.title = title;
        return this;
    }

    public ViewConfigBuilder size(int size) {
        this.size = size;
        return this;
    }

    public ViewConfigBuilder maxSize() {
        return this.size(Integer.MAX_VALUE);
    }

    public ViewConfigBuilder with(@NotNull ViewConfig.Modifier modifier) {
        return this.use(modifier);
    }

    public ViewConfigBuilder with(ViewConfig.Modifier ... modifiers) {
        return this.use(modifiers);
    }

    public ViewConfigBuilder use(@NotNull ViewConfig.Modifier modifier) {
        this.modifiers.add(modifier);
        return this;
    }

    public ViewConfigBuilder use(ViewConfig.Modifier ... modifiers) {
        this.modifiers.addAll(Arrays.asList(modifiers));
        return this;
    }

    public ViewConfigBuilder layout(String ... layout) {
        this.layout = layout;
        return this;
    }

    public ViewConfigBuilder options(ViewConfig.Option<?> ... options) {
        this.options.addAll(Arrays.asList(options));
        return this;
    }

    private ViewConfigBuilder addOption(ViewConfig.Option<?> option) {
        this.options.add(option);
        return this;
    }

    public ViewConfigBuilder cancelOnClick() {
        return this.addOption(ViewConfig.CANCEL_ON_CLICK);
    }

    public ViewConfigBuilder cancelOnPickup() {
        return this.addOption(ViewConfig.CANCEL_ON_PICKUP);
    }

    public ViewConfigBuilder cancelOnDrop() {
        return this.addOption(ViewConfig.CANCEL_ON_DROP);
    }

    public ViewConfigBuilder cancelOnDrag() {
        return this.addOption(ViewConfig.CANCEL_ON_DRAG);
    }

    public ViewConfigBuilder scheduleUpdate(long intervalInTicks) {
        this.updateIntervalInTicks = intervalInTicks;
        return this;
    }

    @ApiStatus.Experimental
    public ViewConfigBuilder interactionDelay(Duration interactionDelay) {
        this.interactionDelayInMillis = interactionDelay == null ? 0L : interactionDelay.toMillis();
        return this;
    }

    public ViewConfigBuilder transitiveInitialData(boolean transitiveInitialData) {
        this.transitiveInitialData = transitiveInitialData;
        return this;
    }

    public ViewConfig build() {
        Map<ViewConfig.Option<?>, Object> optionsMap = this.getOptions().stream().map(option -> new AbstractMap.SimpleImmutableEntry((ViewConfig.Option)option, option.defaultValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return new ViewConfig(this.getTitle(), this.getSize(), this.getType(), optionsMap, this.getLayout(), this.getModifiers(), this.getUpdateIntervalInTicks(), this.getInteractionDelayInMillis(), this.transitiveInitialData);
    }

    public static boolean isTitleAsComponentSupported() {
        return titleAsComponentSupported;
    }

    Object getTitle() {
        return this.title;
    }

    int getSize() {
        return this.size;
    }

    ViewType getType() {
        return this.type;
    }

    Set<ViewConfig.Option<?>> getOptions() {
        return this.options;
    }

    String[] getLayout() {
        return this.layout;
    }

    Set<ViewConfig.Modifier> getModifiers() {
        return this.modifiers;
    }

    long getUpdateIntervalInTicks() {
        return this.updateIntervalInTicks;
    }

    long getInteractionDelayInMillis() {
        return this.interactionDelayInMillis;
    }

    public boolean isTransitiveInitialData() {
        return this.transitiveInitialData;
    }

    static {
        try {
            Class.forName("net.kyori.adventure.text.TextComponent");
            titleAsComponentSupported = true;
        }
        catch (ClassNotFoundException ignored) {
            titleAsComponentSupported = false;
        }
    }
}

