/*
 * Decompiled with CFR 0.152.
 */
package me.devnatan.inventoryframework;

import java.util.Objects;
import java.util.function.Supplier;
import org.intellij.lang.annotations.PrintFormat;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class IFDebug {
    private static final String PREFIX = "[InventoryFramework] [DEBUG] ";
    private static final String SYSTEM_PROPERTY = "me.devnatan.inventoryframework.debug";
    private static Boolean DEBUG_ENABLED = null;

    private IFDebug() {
    }

    public static boolean isDebugEnabled() {
        if (DEBUG_ENABLED == null) {
            DEBUG_ENABLED = Boolean.parseBoolean(System.getProperty(SYSTEM_PROPERTY, "false")) || Objects.equals(System.getenv("DEVELOPMENT"), "true");
        }
        return DEBUG_ENABLED;
    }

    public static void setEnabled(boolean enabled) {
        System.setProperty(SYSTEM_PROPERTY, String.valueOf(enabled));
    }

    public static void debug(Supplier<String> message, Object ... args) {
        if (!IFDebug.isDebugEnabled()) {
            return;
        }
        System.out.printf(PREFIX + message.get() + "%n", args);
    }

    public static void debug(@PrintFormat String message, Object ... args) {
        if (!IFDebug.isDebugEnabled()) {
            return;
        }
        System.out.printf(PREFIX + message + "%n", args);
    }
}

