/*
 * Decompiled with CFR 0.152.
 */
package me.devnatan.inventoryframework.pipeline;

import java.util.List;
import me.devnatan.inventoryframework.pipeline.PipelineInterceptor;
import me.devnatan.inventoryframework.pipeline.PipelinePhase;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public class PipelineContext<S> {
    private final PipelinePhase phase;
    private final List<PipelineInterceptor<S>> interceptors;
    private S subject;
    private int index;

    PipelineContext(PipelinePhase phase, List<PipelineInterceptor<S>> interceptors) {
        this.phase = phase;
        this.interceptors = interceptors;
    }

    @Nullable
    public PipelinePhase getPhase() {
        return this.phase;
    }

    public void finish() {
        this.index = -1;
    }

    private void loop() {
        int pointer;
        while ((pointer = this.index) != -1) {
            List<PipelineInterceptor<S>> safeInterceptors = this.interceptors;
            if (pointer >= safeInterceptors.size()) {
                this.finish();
                break;
            }
            PipelineInterceptor<S> nextInterceptor = safeInterceptors.get(pointer);
            this.index = pointer + 1;
            nextInterceptor.intercept(this, this.subject);
        }
    }

    public void proceed() {
        if (this.index >= this.interceptors.size()) {
            this.finish();
            return;
        }
        this.loop();
    }

    public void execute(S initial) {
        this.index = 0;
        this.subject = initial;
        this.proceed();
    }
}

