/*
 * Decompiled with CFR 0.152.
 */
package me.devnatan.inventoryframework.internal;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntFunction;
import me.devnatan.inventoryframework.component.ComponentFactory;
import org.jetbrains.annotations.Nullable;

public final class LayoutSlot {
    public static final char FILLED_RESERVED_CHAR = 'O';
    private final char character;
    private final IntFunction<ComponentFactory> factory;
    private final int[] positions;

    public LayoutSlot(char character, @Nullable IntFunction<ComponentFactory> factory, int[] positions) {
        this.character = character;
        this.factory = factory;
        this.positions = positions;
    }

    public char getCharacter() {
        return this.character;
    }

    public IntFunction<ComponentFactory> getFactory() {
        return this.factory;
    }

    public LayoutSlot withFactory(@Nullable IntFunction<ComponentFactory> factory) {
        return new LayoutSlot(this.character, factory, this.positions);
    }

    public int[] getPositions() {
        return this.positions;
    }

    public boolean isDefinedByTheUser() {
        return this.factory != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LayoutSlot that = (LayoutSlot)o;
        return this.getCharacter() == that.getCharacter();
    }

    public int hashCode() {
        return Objects.hash(Character.valueOf(this.getCharacter()));
    }

    public String toString() {
        return "LayoutSlot{character=" + this.character + ", factory=" + this.factory + ", positions=" + Arrays.toString(this.positions) + '}';
    }
}

