/*
 * Decompiled with CFR 0.152.
 */
package me.devnatan.inventoryframework.internal;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.TestOnly;

public interface Job {
    public boolean isStarted();

    public void start();

    public void cancel();

    @ApiStatus.Internal
    default public void loop() {
    }

    @ApiStatus.Internal
    public static class InternalJobImpl
    implements Job {
        private final Runnable job;
        private boolean started;

        public InternalJobImpl(Runnable job) {
            this.job = job;
        }

        public String toString() {
            return "InternalJobImpl{job=" + this.job + ", started=" + this.started + '}';
        }

        @Override
        public boolean isStarted() {
            return this.started;
        }

        @Override
        public void start() {
            this.started = true;
        }

        @Override
        public void cancel() {
            this.started = false;
        }

        @Override
        public void loop() {
            this.job.run();
        }

        @TestOnly
        public void setStarted(boolean started) {
            this.started = started;
        }
    }
}

